/// <reference path="./internal_*.d.ts" />
declare namespace com.illusivesoulworks.polymorph.mixin.core {
    interface AccessorCraftingMenu {
        abstract getCraftSlots(): Internal.CraftingContainer;
        abstract getPlayer(): Internal.Player;
        abstract getResultSlots(): Internal.ResultContainer;
        get craftSlots(): Internal.CraftingContainer
        get player(): Internal.Player
        get resultSlots(): Internal.ResultContainer
    }
    type AccessorCraftingMenu_ = AccessorCraftingMenu;
}
declare namespace Internal {
    class DepotBlock extends Internal.Block implements Internal.ProperWaterloggedBlock, com.simibubi.create.content.equipment.wrench.IWrenchable, Internal.IBE<Internal.DepotBlockEntity> {
        constructor(p_i48440_1_: Internal.BlockBehaviour$Properties_)
        newBlockEntity(p_153215_: BlockPos_, p_153216_: Internal.BlockState_): Internal.BlockEntity;
        canPlaceLiquid($$0: Internal.BlockGetter_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.Fluid_): boolean;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        static onRemove(blockState: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, newBlockState: Internal.BlockState_): void;
        updateWater(level: Internal.LevelAccessor_, state: Internal.BlockState_, pos: BlockPos_): void;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getBlockEntityClass(): typeof Internal.DepotBlockEntity;
        getBlockEntityOptional(world: Internal.BlockGetter_, pos: BlockPos_): Internal.Optional<Internal.DepotBlockEntity>;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        withBlockEntityDo(world: Internal.BlockGetter_, pos: BlockPos_, action: Internal.Consumer_<Internal.DepotBlockEntity>): void;
        pickupBlock($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_): Internal.ItemStack;
        getPickupSound(): Internal.Optional<Internal.SoundEvent>;
        getBlockEntityType(): Internal.BlockEntityType<Internal.DepotBlockEntity>;
        getBlockStates(): Internal.List<Internal.BlockState>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        fluidState(state: Internal.BlockState_): Internal.FluidState;
        getBlockEntity(worldIn: Internal.BlockGetter_, pos: BlockPos_): Internal.DepotBlockEntity;
        setRequiresTool(v: boolean): void;
        static withWater(level: Internal.LevelAccessor_, placementState: Internal.BlockState_, pos: BlockPos_): Internal.BlockState;
        onSneakWrenched(state: Internal.BlockState_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        withWater(placementState: Internal.BlockState_, ctx: Internal.BlockPlaceContext_): Internal.BlockState;
        getMod(): string;
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        updateAfterWrenched(newState: Internal.BlockState_, context: Internal.UseOnContext_): Internal.BlockState;
        onWrenched(state: Internal.BlockState_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getRotatedBlockState(originalState: Internal.BlockState_, targetedFace: Internal.Direction_): Internal.BlockState;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        static playRemoveSound(level: Internal.Level_, pos: BlockPos_): void;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        onBlockEntityUse(world: Internal.BlockGetter_, pos: BlockPos_, action: Internal.Function_<Internal.DepotBlockEntity, Internal.InteractionResult>): Internal.InteractionResult;
        placeLiquid($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.FluidState_): boolean;
        getListener<T extends Internal.BlockEntity>($$0: Internal.ServerLevel_, $$1: T): Internal.GameEventListener;
        arch$holder(): Internal.Holder<Internal.Block>;
        emi(amount: number): Internal.EmiStack;
        getTicker<S extends Internal.BlockEntity>(p_153212_: Internal.Level_, p_153213_: Internal.BlockState_, p_153214_: Internal.BlockEntityType_<S>): Internal.BlockEntityTicker<S>;
        static playRotateSound(level: Internal.Level_, pos: BlockPos_): void;
        emi(): Internal.EmiStack;
        get blockEntityClass(): typeof Internal.DepotBlockEntity
        get pickupSound(): Internal.Optional<Internal.SoundEvent>
        get blockEntityType(): Internal.BlockEntityType<Internal.DepotBlockEntity>
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        set destroySpeed(v: number)
    }
    type DepotBlock_ = DepotBlock;
    interface RegistryAccess extends Internal.HolderLookup$Provider {
        lookup<T>($$0: Internal.ResourceKey_<Internal.Registry<T>>): Internal.Optional<Internal.HolderLookup$RegistryLookup<T>>;
        allRegistriesLifecycle(): Internal.Lifecycle;
        create($$0: Internal.Stream_<Internal.HolderLookup$RegistryLookup<any>>): Internal.HolderLookup$Provider;
        abstract registry<E>(arg0: Internal.ResourceKey_<Internal.Registry<E>>): Internal.Optional<Internal.Registry<E>>;
        lookupOrThrow<T>($$0: Internal.ResourceKey_<Internal.Registry<T>>): Internal.HolderLookup$RegistryLookup<T>;
        registryOrThrow<E>($$0: Internal.ResourceKey_<Internal.Registry<E>>): Internal.Registry<E>;
        freeze(): Internal.RegistryAccess$Frozen;
        abstract registries(): Internal.Stream<Internal.RegistryAccess$RegistryEntry<any>>;
        asGetterLookup(): Internal.HolderGetter$Provider;
        fromRegistryOfRegistries($$0: Internal.Registry_<Internal.Registry<any>>): Internal.RegistryAccess$Frozen;
        readonly EMPTY: Internal.RegistryAccess$1FrozenAccess;
        readonly LOGGER: Internal.Log4jLogger;
    }
    type RegistryAccess_ = RegistryAccess;
    class ComplexDoubleMatrix {
        constructor()
        constructor(arg0: number, arg1: number)
        constructor(arg0: Internal.DoubleMatrix_, arg1: Internal.DoubleMatrix_)
        constructor(arg0: Internal.ComplexDouble_[])
        constructor(arg0: number, arg1: number, ...arg2: number[])
        constructor(arg0: number)
        constructor(arg0: number[])
        constructor(arg0: number[][])
        constructor(arg0: string)
        constructor(arg0: Internal.DoubleMatrix_)
        ori(arg0: number): this;
        put(arg0: number, arg1: number[], arg2: number): this;
        get(arg0: number[], arg1: number[]): this;
        rdiv(arg0: Internal.ComplexDouble_): this;
        put(arg0: number, arg1: Internal.ComplexDoubleMatrix_, arg2: number): this;
        put(arg0: number, arg1: number, arg2: number): this;
        out(arg0: Internal.DataOutputStream_): void;
        add(arg0: Internal.ComplexDouble_): this;
        get(arg0: number[]): this;
        mmuli(arg0: number, arg1: Internal.ComplexDoubleMatrix_): this;
        imag(): Internal.DoubleMatrix;
        getReal(arg0: number): number;
        mmuli(arg0: Internal.ComplexDoubleMatrix_): this;
        subi(arg0: number): this;
        dup(): this;
        put(arg0: Internal.ComplexDoubleMatrix_, arg1: number, arg2: number): this;
        putImag(arg0: number, arg1: number[], arg2: number): this;
        xor(arg0: Internal.ComplexDouble_): this;
        sub(arg0: Internal.ComplexDoubleMatrix_): this;
        isVector(): boolean;
        or(arg0: number): this;
        subi(arg0: Internal.ComplexDouble_): this;
        getLength(): number;
        nei(arg0: Internal.ComplexDouble_): this;
        eqi(arg0: Internal.ComplexDouble_, arg1: Internal.ComplexDoubleMatrix_): this;
        static zeros(arg0: number): Internal.ComplexDoubleMatrix;
        or(arg0: Internal.ComplexDouble_): this;
        put(arg0: Internal.ComplexDoubleMatrix_, arg1: number, arg2: Internal.ComplexDouble_): this;
        add(arg0: number): this;
        nei(arg0: number): this;
        xori(arg0: number): this;
        put(arg0: Internal.ComplexDoubleMatrix_, arg1: Internal.ComplexDoubleMatrix_, arg2: number): this;
        div(arg0: Internal.ComplexDouble_): this;
        rdiv(arg0: number): this;
        put(arg0: number[], arg1: number, arg2: Internal.ComplexDoubleMatrix_): this;
        get(arg0: number, arg1: Internal.ComplexDoubleMatrix_): this;
        rdivi(arg0: number, arg1: Internal.ComplexDoubleMatrix_): this;
        rdivi(arg0: Internal.ComplexDoubleMatrix_, arg1: Internal.ComplexDoubleMatrix_): this;
        static ones(arg0: number): Internal.ComplexDoubleMatrix;
        putImag(arg0: number, arg1: Internal.ComplexDoubleMatrix_, arg2: number): this;
        static diag(arg0: Internal.ComplexDoubleMatrix_): Internal.ComplexDoubleMatrix;
        assertSameSize(arg0: Internal.ComplexDoubleMatrix_): void;
        isSquare(): boolean;
        addi(arg0: number): this;
        rsubi(arg0: Internal.ComplexDoubleMatrix_): this;
        mul(arg0: Internal.ComplexDouble_): this;
        noti(): this;
        ne(arg0: Internal.ComplexDoubleMatrix_): this;
        scalar(): Internal.ComplexDouble;
        rsubi(arg0: number): this;
        rdivi(arg0: Internal.ComplexDoubleMatrix_): this;
        mmuli(arg0: Internal.ComplexDoubleMatrix_, arg1: Internal.ComplexDoubleMatrix_): this;
        xori(arg0: Internal.ComplexDouble_): this;
        put(arg0: number, arg1: number[], arg2: Internal.ComplexDouble_): this;
        addi(arg0: Internal.ComplexDouble_): this;
        putImag(arg0: Internal.ComplexDoubleMatrix_, arg1: Internal.ComplexDoubleMatrix_, arg2: number): this;
        put(arg0: number, arg1: Internal.ComplexDoubleMatrix_, arg2: Internal.ComplexDouble_): this;
        rankOneUpdate(arg0: number, arg1: Internal.ComplexDoubleMatrix_, arg2: Internal.ComplexDoubleMatrix_): this;
        rsub(arg0: Internal.ComplexDoubleMatrix_): this;
        get(arg0: number, arg1: Internal.ComplexDouble_): Internal.ComplexDouble;
        mul(arg0: number): this;
        put(arg0: number[], arg1: number[], arg2: number): this;
        addColumnVector(arg0: Internal.ComplexDoubleMatrix_): void;
        put(arg0: number, arg1: Internal.ComplexDouble_): this;
        toArray(): Internal.ComplexDouble[];
        sub(arg0: number): this;
        eq(arg0: Internal.ComplexDoubleMatrix_): this;
        get(arg0: number, arg1: number[]): this;
        toBooleanArray(): boolean[];
        conj(): this;
        eq(arg0: Internal.ComplexDouble_): this;
        putReal(arg0: Internal.ComplexDoubleMatrix_, arg1: Internal.ComplexDoubleMatrix_, arg2: number): this;
        ori(arg0: Internal.ComplexDouble_, arg1: Internal.ComplexDoubleMatrix_): this;
        multipliesWith(arg0: Internal.ComplexDoubleMatrix_): boolean;
        swapColumns(arg0: number, arg1: number): this;
        rankOneUpdate(arg0: Internal.ComplexDoubleMatrix_): this;
        putReal(arg0: number[], arg1: number, arg2: number): this;
        xor(arg0: number): this;
        not(): this;
        divi(arg0: number): this;
        eqi(arg0: number, arg1: Internal.ComplexDoubleMatrix_): this;
        eqi(arg0: Internal.ComplexDoubleMatrix_, arg1: Internal.ComplexDoubleMatrix_): this;
        assertSquare(): void;
        ori(arg0: Internal.ComplexDoubleMatrix_): this;
        assertMultipliesWith(arg0: Internal.ComplexDoubleMatrix_): void;
        isColumnVector(): boolean;
        static ones(arg0: number, arg1: number): Internal.ComplexDoubleMatrix;
        isEmpty(): boolean;
        eqi(arg0: Internal.ComplexDouble_): this;
        put(arg0: Internal.ComplexDoubleMatrix_, arg1: number, arg2: Internal.ComplexDoubleMatrix_): this;
        ori(arg0: Internal.ComplexDouble_): this;
        findIndices(): number[];
        rdivi(arg0: Internal.ComplexDouble_, arg1: Internal.ComplexDoubleMatrix_): this;
        toBooleanArray2(): boolean[][];
        putImag(arg0: Internal.ComplexDoubleMatrix_, arg1: number, arg2: number): this;
        putReal(arg0: number[], arg1: number[], arg2: number): this;
        muli(arg0: number): this;
        putImag(arg0: number[], arg1: number): this;
        sum(): Internal.ComplexDouble;
        eqi(arg0: Internal.ComplexDoubleMatrix_): this;
        swapRows(arg0: number, arg1: number): this;
        sameSize(arg0: Internal.ComplexDoubleMatrix_): boolean;
        get(arg0: Internal.ComplexDoubleMatrix_): this;
        getRow(arg0: number): this;
        indexRows(arg0: number): number;
        put(arg0: number, arg1: number, arg2: number): this;
        ori(arg0: number, arg1: Internal.ComplexDoubleMatrix_): this;
        ori(arg0: Internal.ComplexDoubleMatrix_, arg1: Internal.ComplexDoubleMatrix_): this;
        toArray2(): Internal.ComplexDouble[][];
        isRowVector(): boolean;
        and(arg0: Internal.ComplexDouble_): this;
        andi(arg0: number): this;
        print(): void;
        mean(): Internal.ComplexDouble;
        norm1(): number;
        put(arg0: Internal.ComplexDoubleMatrix_, arg1: Internal.ComplexDouble_): this;
        getRows(): number;
        putImag(arg0: Internal.ComplexDoubleMatrix_, arg1: number): this;
        negi(): this;
        put(arg0: Internal.ComplexDoubleMatrix_, arg1: Internal.ComplexDoubleMatrix_): this;
        mmul(arg0: number): this;
        get(arg0: Internal.ComplexDoubleMatrix_, arg1: Internal.ComplexDoubleMatrix_): this;
        put(arg0: number[], arg1: Internal.ComplexDouble_): this;
        and(arg0: Internal.ComplexDoubleMatrix_): this;
        put(arg0: number[], arg1: Internal.ComplexDoubleMatrix_): this;
        add(arg0: Internal.ComplexDoubleMatrix_): this;
        mmuli(arg0: Internal.ComplexDouble_): this;
        static scalar(arg0: number): Internal.ComplexDoubleMatrix;
        nei(arg0: Internal.ComplexDoubleMatrix_): this;
        rowSums(): this;
        putReal(arg0: Internal.ComplexDoubleMatrix_, arg1: number): this;
        subColumnVector(arg0: Internal.ComplexDoubleMatrix_): void;
        subi(arg0: number, arg1: Internal.ComplexDoubleMatrix_): this;
        subi(arg0: Internal.ComplexDoubleMatrix_, arg1: Internal.ComplexDoubleMatrix_): this;
        xori(arg0: Internal.ComplexDoubleMatrix_): this;
        putReal(arg0: number[], arg1: number): this;
        divi(arg0: Internal.ComplexDouble_, arg1: Internal.ComplexDoubleMatrix_): this;
        normmax(): number;
        xori(arg0: number, arg1: Internal.ComplexDoubleMatrix_): this;
        xori(arg0: Internal.ComplexDoubleMatrix_, arg1: Internal.ComplexDoubleMatrix_): this;
        nei(arg0: number, arg1: Internal.ComplexDoubleMatrix_): this;
        copy(arg0: Internal.ComplexDoubleMatrix_): this;
        rowMeans(): this;
        norm2(): number;
        getColumn(arg0: number): this;
        putReal(arg0: number, arg1: number, arg2: number): this;
        reshape(arg0: number, arg1: number): this;
        rankOneUpdate(arg0: Internal.ComplexDoubleMatrix_, arg1: Internal.ComplexDoubleMatrix_): this;
        put(arg0: number, arg1: number, arg2: number, arg3: number): this;
        putColumn(arg0: number, arg1: Internal.ComplexDoubleMatrix_): void;
        rankOneUpdate(arg0: number, arg1: Internal.ComplexDoubleMatrix_): this;
        or(arg0: Internal.ComplexDoubleMatrix_): this;
        sub(arg0: Internal.ComplexDouble_): this;
        xor(arg0: Internal.ComplexDoubleMatrix_): this;
        rdiv(arg0: Internal.ComplexDoubleMatrix_): this;
        resize(arg0: number, arg1: number): void;
        get(arg0: number): Internal.ComplexDouble;
        rsubi(arg0: Internal.ComplexDouble_, arg1: Internal.ComplexDoubleMatrix_): this;
        putReal(arg0: number, arg1: Internal.ComplexDoubleMatrix_, arg2: number): this;
        columnMeans(): this;
        conji(): this;
        get(arg0: number, arg1: number): Internal.ComplexDouble;
        andi(arg0: Internal.ComplexDouble_, arg1: Internal.ComplexDoubleMatrix_): this;
        save(arg0: string): void;
        neg(): this;
        putReal(arg0: Internal.ComplexDoubleMatrix_, arg1: number, arg2: number): this;
        addi(arg0: number, arg1: Internal.ComplexDoubleMatrix_): this;
        put(arg0: number, arg1: Internal.ComplexDoubleMatrix_, arg2: Internal.ComplexDoubleMatrix_): this;
        addi(arg0: Internal.ComplexDoubleMatrix_, arg1: Internal.ComplexDoubleMatrix_): this;
        putReal(arg0: number, arg1: number[], arg2: number): this;
        mmuli(arg0: number): this;
        rdivi(arg0: number): this;
        mul(arg0: Internal.ComplexDoubleMatrix_): this;
        put(arg0: number, arg1: number[], arg2: Internal.ComplexDoubleMatrix_): this;
        columnSums(): this;
        rankOneUpdate(arg0: Internal.ComplexDouble_, arg1: Internal.ComplexDoubleMatrix_): this;
        put(arg0: number[], arg1: number, arg2: Internal.ComplexDouble_): this;
        div(arg0: Internal.ComplexDoubleMatrix_): this;
        nei(arg0: Internal.ComplexDoubleMatrix_, arg1: Internal.ComplexDoubleMatrix_): this;
        ne(arg0: Internal.ComplexDouble_): this;
        rsub(arg0: number): this;
        subRowVector(arg0: Internal.ComplexDoubleMatrix_): void;
        put(arg0: number, arg1: number): this;
        put(arg0: number[], arg1: number, arg2: number): this;
        muli(arg0: Internal.ComplexDouble_, arg1: Internal.ComplexDoubleMatrix_): this;
        rsub(arg0: Internal.ComplexDouble_): this;
        dotu(arg0: Internal.ComplexDoubleMatrix_): Internal.ComplexDouble;
        index(arg0: number, arg1: number): number;
        putImag(arg0: number, arg1: number): this;
        addi(arg0: Internal.ComplexDoubleMatrix_): this;
        addRowVector(arg0: Internal.ComplexDoubleMatrix_): void;
        ne(arg0: number): this;
        rdivi(arg0: Internal.ComplexDouble_): this;
        putImag(arg0: number[], arg1: number, arg2: number): this;
        rsubi(arg0: number, arg1: Internal.ComplexDoubleMatrix_): this;
        put(arg0: Internal.ComplexDoubleMatrix_, arg1: Internal.ComplexDoubleMatrix_, arg2: Internal.ComplexDouble_): this;
        indexColumns(arg0: number): number;
        and(arg0: number): this;
        static diag(arg0: Internal.ComplexDoubleMatrix_, arg1: number, arg2: number): Internal.ComplexDoubleMatrix;
        truthi(): this;
        putImag(arg0: number, arg1: number, arg2: number): this;
        hermitian(): this;
        diag(): this;
        rsubi(arg0: Internal.ComplexDoubleMatrix_, arg1: Internal.ComplexDoubleMatrix_): this;
        rsubi(arg0: Internal.ComplexDouble_): this;
        isScalar(): boolean;
        put(arg0: Internal.ComplexDoubleMatrix_, arg1: Internal.ComplexDoubleMatrix_, arg2: Internal.ComplexDoubleMatrix_): this;
        div(arg0: number): this;
        putRow(arg0: number, arg1: Internal.ComplexDoubleMatrix_): void;
        subi(arg0: Internal.ComplexDouble_, arg1: Internal.ComplexDoubleMatrix_): this;
        load(arg0: string): void;
        assertSameLength(arg0: Internal.ComplexDoubleMatrix_): void;
        eq(arg0: number): this;
        nei(arg0: Internal.ComplexDouble_, arg1: Internal.ComplexDoubleMatrix_): this;
        static zeros(arg0: number, arg1: number): Internal.ComplexDoubleMatrix;
        putReal(arg0: number, arg1: number): this;
        transpose(): this;
        mmuli(arg0: Internal.ComplexDouble_, arg1: Internal.ComplexDoubleMatrix_): this;
        get(arg0: number[], arg1: number): this;
        put(arg0: Internal.ComplexDoubleMatrix_, arg1: number): this;
        andi(arg0: number, arg1: Internal.ComplexDoubleMatrix_): this;
        dotc(arg0: Internal.ComplexDoubleMatrix_): Internal.ComplexDouble;
        getReal(): Internal.DoubleMatrix;
        put(arg0: number[], arg1: number): this;
        get(arg0: number, arg1: number, arg2: Internal.ComplexDouble_): Internal.ComplexDouble;
        put(arg0: number, arg1: number, arg2: Internal.ComplexDouble_): this;
        subi(arg0: Internal.ComplexDoubleMatrix_): this;
        get(arg0: Internal.ComplexDoubleMatrix_, arg1: number): this;
        "in"(arg0: Internal.DataInputStream_): void;
        rankOneUpdate(arg0: Internal.ComplexDouble_, arg1: Internal.ComplexDoubleMatrix_, arg2: Internal.ComplexDoubleMatrix_): this;
        andi(arg0: Internal.ComplexDouble_): this;
        mmul(arg0: Internal.ComplexDouble_): this;
        getImag(arg0: number): number;
        real(): Internal.DoubleMatrix;
        addi(arg0: Internal.ComplexDouble_, arg1: Internal.ComplexDoubleMatrix_): this;
        muli(arg0: Internal.ComplexDoubleMatrix_, arg1: Internal.ComplexDoubleMatrix_): this;
        muli(arg0: number, arg1: Internal.ComplexDoubleMatrix_): this;
        putImag(arg0: number[], arg1: number[], arg2: number): this;
        static concatHorizontally(arg0: Internal.ComplexDoubleMatrix_, arg1: Internal.ComplexDoubleMatrix_): Internal.ComplexDoubleMatrix;
        eqi(arg0: number): this;
        muli(arg0: Internal.ComplexDoubleMatrix_): this;
        truth(): this;
        muli(arg0: Internal.ComplexDouble_): this;
        mmul(arg0: Internal.ComplexDoubleMatrix_): this;
        andi(arg0: Internal.ComplexDoubleMatrix_): this;
        divi(arg0: Internal.ComplexDoubleMatrix_, arg1: Internal.ComplexDoubleMatrix_): this;
        divi(arg0: number, arg1: Internal.ComplexDoubleMatrix_): this;
        static concatVertically(arg0: Internal.ComplexDoubleMatrix_, arg1: Internal.ComplexDoubleMatrix_): Internal.ComplexDoubleMatrix;
        put(arg0: number[], arg1: number[], arg2: Internal.ComplexDoubleMatrix_): this;
        xori(arg0: Internal.ComplexDouble_, arg1: Internal.ComplexDoubleMatrix_): this;
        andi(arg0: Internal.ComplexDoubleMatrix_, arg1: Internal.ComplexDoubleMatrix_): this;
        getColumns(): number;
        toDoubleArray(): number[];
        divi(arg0: Internal.ComplexDouble_): this;
        divi(arg0: Internal.ComplexDoubleMatrix_): this;
        put(arg0: number[], arg1: number[], arg2: Internal.ComplexDouble_): this;
        sameLength(arg0: Internal.ComplexDoubleMatrix_): boolean;
        get vector(): boolean
        get length(): number
        get square(): boolean
        get columnVector(): boolean
        get empty(): boolean
        get rowVector(): boolean
        get rows(): number
        get scalar(): boolean
        get real(): Internal.DoubleMatrix
        get columns(): number
        data: number[];
        length: number;
        rows: number;
        columns: number;
    }
    type ComplexDoubleMatrix_ = ComplexDoubleMatrix;
    class GoldenPipeBlock extends Internal.BooleanDirectionsPipeBlock {
        constructor(properties: Internal.BlockBehaviour$Properties_)
        static get($$0: Internal.ItemStack_): Internal.Equipable;
        canPlaceLiquid($$0: Internal.BlockGetter_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.Fluid_): boolean;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        pickupBlock($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_): Internal.ItemStack;
        getPickupSound(): Internal.Optional<Internal.SoundEvent>;
        getBlockStates(): Internal.List<Internal.BlockState>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        setRequiresTool(v: boolean): void;
        getTicker<T extends Internal.BlockEntity>(level: Internal.Level_, state: Internal.BlockState_, blockEntityType: Internal.BlockEntityType_<T>): Internal.BlockEntityTicker<T>;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getEquipSound(): Internal.SoundEvent;
        getMod(): string;
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        placeLiquid($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.FluidState_): boolean;
        getListener<T extends Internal.BlockEntity>($$0: Internal.ServerLevel_, $$1: T): Internal.GameEventListener;
        arch$holder(): Internal.Holder<Internal.Block>;
        emi(amount: number): Internal.EmiStack;
        emi(): Internal.EmiStack;
        get pickupSound(): Internal.Optional<Internal.SoundEvent>
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get equipSound(): Internal.SoundEvent
        get mod(): string
        set destroySpeed(v: number)
    }
    type GoldenPipeBlock_ = GoldenPipeBlock;
    interface AttributeSet$ParagraphAttribute {
    }
    type AttributeSet$ParagraphAttribute_ = AttributeSet$ParagraphAttribute;
    class DensityFunctions$Constant extends Internal.Record implements Internal.DensityFunction$SimpleFunction {
        halfNegative(): Internal.DensityFunction;
        abs(): Internal.DensityFunction;
        maxValue(): number;
        codec(): Internal.KeyDispatchDataCodec<Internal.DensityFunction>;
        compute($$0: Internal.DensityFunction$FunctionContext_): number;
        squeeze(): Internal.DensityFunction;
        square(): Internal.DensityFunction;
        mapAll($$0: Internal.DensityFunction$Visitor_): Internal.DensityFunction;
        clamp($$0: number, $$1: number): Internal.DensityFunction;
        quarterNegative(): Internal.DensityFunction;
        cube(): Internal.DensityFunction;
        value(): number;
        fillArray($$0: number[], $$1: Internal.DensityFunction$ContextProvider_): void;
        minValue(): number;
    }
    type DensityFunctions$Constant_ = DensityFunctions$Constant;
    interface ClickableWidgetAccessor {
        abstract owo$setWidth(arg0: number): void;
        abstract owo$setHeight(arg0: number): void;
        abstract owo$setY(arg0: number): void;
        abstract owo$setX(arg0: number): void;
        abstract owo$getTooltip(): Internal.Tooltip;
    }
    type ClickableWidgetAccessor_ = ClickableWidgetAccessor;
    interface ILinkable {
        abstract numLinked(): number;
        abstract getLinkableType(): Internal.LinkableRegistry$LinkableType<any, any>;
        abstract getPosition(): Vec3d;
        abstract nextReceivedIota(): Internal.Iota;
        abstract currentMediaLevel(): number;
        abstract allReceivedIotas(): Internal.List<Internal.Iota>;
        abstract transmittingTargetReturnDisplay(): Internal.List<net.minecraft.network.chat.Component>;
        abstract checkLinks(): void;
        abstract numRemainingIota(): number;
        abstract unlink(arg0: Internal.ILinkable_, arg1: boolean): void;
        abstract acceptMedia(arg0: Internal.ILinkable_, arg1: number): void;
        abstract maxSqrLinkRange(): number;
        abstract getLinked(arg0: number): this;
        abstract isInRange(arg0: Internal.ILinkable_): boolean;
        abstract clearReceivedIotas(): void;
        abstract canAcceptMedia(arg0: Internal.ILinkable_, arg1: number): number;
        abstract getLinkableHolder(): Internal.ServerLinkableHolder;
        abstract shouldRemove(): boolean;
        abstract owner(): Internal.UUID;
        abstract link(arg0: Internal.ILinkable_, arg1: boolean): void;
        abstract receiveIota(arg0: Internal.ILinkable_, arg1: Internal.Iota_): void;
        abstract getLinkedIndex(arg0: Internal.ILinkable_): number;
        abstract getAsActionResult(): Internal.List<Internal.Iota>;
        get linkableType(): Internal.LinkableRegistry$LinkableType<any, any>
        get position(): Vec3d
        get linkableHolder(): Internal.ServerLinkableHolder
        get asActionResult(): Internal.List<Internal.Iota>
        readonly MAX_RECEIVED_IOTAS: 64;
        readonly Companion: Internal.ILinkable$Companion;
    }
    type ILinkable_ = ILinkable;
    class BlockExplodedCallbackJS {
        constructor(level: Internal.Level_, pos: BlockPos_, explosion: Internal.Explosion_)
        getLevel(): Internal.Level;
        getRadius(): number;
        getDamageSource(): DamageSource;
        getExplosion(): Internal.Explosion;
        getBlockState(): Internal.BlockState;
        getAffectedPlayers(): Internal.List<Internal.Player>;
        getCause(): Internal.Entity;
        getIgniter(): Internal.LivingEntity;
        getBlock(): Internal.BlockContainerJS;
        get level(): Internal.Level
        get radius(): number
        get damageSource(): DamageSource
        get explosion(): Internal.Explosion
        get blockState(): Internal.BlockState
        get affectedPlayers(): Internal.List<Internal.Player>
        get cause(): Internal.Entity
        get igniter(): Internal.LivingEntity
        get block(): Internal.BlockContainerJS
    }
    type BlockExplodedCallbackJS_ = BlockExplodedCallbackJS;
    class Evoker extends Internal.SpellcasterIllager {
        constructor($$0: Internal.EntityType_<Internal.Evoker>, $$1: Internal.Level_)
        getDistance(pos: BlockPos_): number;
        splitIntoDynamicLightEntries(cellHasher: Internal.CellHasher_): Internal.Stream<Internal.SpatialLookupEntry>;
        damageHeldItem(hand: Internal.InteractionHand_, amount: number): void;
        removeAttribute(attribute: Internal.Attribute_, identifier: string): void;
        playSound(id: Internal.SoundEvent_, volume: number, pitch: number): void;
        static port_lib$collideWithShapes(vec3: Vec3d_, aABB: Internal.AABB_, list: Internal.List_<Internal.VoxelShape>): Vec3d;
        damageEquipment(slot: Internal.EquipmentSlot_, amount: number, onBroken: Internal.Consumer_<Internal.ItemStack>): void;
        setDefaultMovementSpeedMultiplier(speed: number): void;
        isTouchingUpsideDownFluid(): boolean;
        getOffHandItem(): Internal.ItemStack;
        isOnScoreboardTeam(teamId: string): boolean;
        getAttachedOrSet<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        getEquipment(slot: Internal.EquipmentSlot_): Internal.ItemStack;
        removeAttached<A>(type: Internal.AttachmentType_<A>): A;
        swing(): void;
        setPosition(x: number, y: number, z: number): void;
        runCommandSilent(command: string): number;
        isPlayer(): boolean;
        isAnimal(): boolean;
        rayTrace(distance: number, fluids: boolean): Internal.RayTraceResultJS;
        asComponentProvider(): Internal.ComponentProvider;
        setY(y: number): void;
        isLiving(): boolean;
        damageEquipment(slot: Internal.EquipmentSlot_): void;
        static tickEntity(entity: Internal.Entity_): void;
        static transfer(original: Internal.AttachmentTarget_, target: Internal.AttachmentTarget_, isDeath: boolean): void;
        rayTrace(): Internal.RayTraceResultJS;
        getTotalMovementSpeed(): number;
        alwaysAccepts(): boolean;
        getCustomData(): Internal.CompoundTag;
        damageHeldItem(): void;
        getDisplayName(): net.minecraft.network.chat.Component;
        setPosition(block: Internal.BlockContainerJS_): void;
        setMotionZ(z: number): void;
        mergeNbt(tag: Internal.CompoundTag_): Internal.Entity;
        attack(hp: number): void;
        lambdynlights$scheduleTrackedChunksRebuild(renderer: Internal.LevelRenderer_): void;
        getTeamId(): string;
        setMaxHealth(hp: number): void;
        getFacing(): Internal.Direction;
        canRiderInteract(): boolean;
        getLegsArmorItem(): Internal.ItemStack;
        setMainHandItem(item: Internal.ItemStack_): void;
        isHoldingInAnyHand(i: Internal.Ingredient_): boolean;
        captureDrops(value: Internal.Collection_<Internal.ItemEntity>): Internal.Collection<Internal.ItemEntity>;
        rayTrace(distance: number): Internal.RayTraceResultJS;
        getReachDistance(): number;
        getMotionX(): number;
        isWaterCreature(): boolean;
        getItem(): Internal.ItemStack;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_, predicate: Internal.PlayerSyncPredicate_): void;
        setX(x: number): void;
        setAttributeBaseValue(attribute: Internal.Attribute_, value: number): void;
        getDynamicLightChunksToRebuild(forced: boolean): Internal.LongSet;
        getPotionEffects(): Internal.EntityPotionEffectsJS;
        isFrame(): boolean;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>, initializer: Internal.Supplier_<A>): A;
        setLegsArmorItem(item: Internal.ItemStack_): void;
        playSound(id: Internal.SoundEvent_): void;
        foodEaten(is: Internal.ItemStack_): void;
        getAttachedOrThrow<A>(type: Internal.AttachmentType_<A>): A;
        getDefaultMovementSpeed(): number;
        getHeldItem(hand: Internal.InteractionHand_): Internal.ItemStack;
        swing(hand: Internal.InteractionHand_): void;
        getDistance(x: number, y: number, z: number): number;
        setMotionY(y: number): void;
        static createAttributes(): Internal.AttributeSupplier$Builder;
        getAttributeTotalValue(attribute: Internal.Attribute_): number;
        isPeacefulCreature(): boolean;
        syncComponent(key: Internal.ComponentKey_<any>): void;
        isUndead(): boolean;
        setRotation(yaw: number, pitch: number): void;
        modifyAttached<A>(type: Internal.AttachmentType_<A>, modifier: Internal.UnaryOperator_<A>): A;
        isDynamicLightEnabled(): boolean;
        isAmbientCreature(): boolean;
        isMonster(): boolean;
        getType(): string;
        self(): Internal.Entity;
        setChestArmorItem(item: Internal.ItemStack_): void;
        checkUpsideDownState(): void;
        getTouchingFluid(): Internal.FluidState;
        getBlock(): Internal.BlockContainerJS;
        getNbt(): Internal.CompoundTag;
        getComponent<C extends dev.onyxstudios.cca.api.v3.component.Component>(key: Internal.ComponentKey_<C>): C;
        setEquipment(slot: Internal.EquipmentSlot_, item: Internal.ItemStack_): void;
        getMotionY(): number;
        getName(): net.minecraft.network.chat.Component;
        getPassengers(): Internal.EntityArrayList;
        setTotalMovementSpeedMultiplier(speed: number): void;
        sophisticatedInvalidateCaps(): void;
        lithiumOnEquipmentChanged(): void;
        getAttachedOrGet<A>(type: Internal.AttachmentType_<A>, defaultValue: Internal.Supplier_<A>): A;
        setHeldItem(hand: Internal.InteractionHand_, item: Internal.ItemStack_): void;
        etf$getETFRenderState(): Internal.ETFEntityRenderState;
        damageHeldItem(hand: Internal.InteractionHand_, amount: number, onBroken: Internal.Consumer_<Internal.ItemStack>): void;
        getFeetArmorItem(): Internal.ItemStack;
        setDefaultMovementSpeed(speed: number): void;
        setOffHandItem(item: Internal.ItemStack_): void;
        getMainHandItem(): Internal.ItemStack;
        spawn(): void;
        getServer(): Internal.MinecraftServer;
        setMotionX(x: number): void;
        canEntityBeSeen(entity: Internal.LivingEntity_): boolean;
        teleportTo(dimension: ResourceLocation_, x: number, y: number, z: number, yaw: number, pitch: number): void;
        static gatherClosestChunks(chunks: Internal.LongSet_, x: number, y: number, z: number): void;
        captureDrops(): Internal.Collection<Internal.ItemEntity>;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>): A;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_): void;
        setNbt(nbt: Internal.CompoundTag_): void;
        getLevel(): Internal.Level;
        getScriptType(): Internal.ScriptType;
        setMovementSpeedAddition(speed: number): void;
        serializeNBT(): Internal.Tag;
        getHeadArmorItem(): Internal.ItemStack;
        modifyAttribute(attribute: Internal.Attribute_, identifier: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        setDynamicLightEnabled(enabled: boolean): void;
        setFeetArmorItem(item: Internal.ItemStack_): void;
        setPositionAndRotation(x: number, y: number, z: number, yaw: number, pitch: number): void;
        getChestArmorItem(): Internal.ItemStack;
        damageEquipment(slot: Internal.EquipmentSlot_, amount: number): void;
        getMotionZ(): number;
        lambdynlights$updateDynamicLight(renderer: Internal.LevelRenderer_): boolean;
        tell(message: net.minecraft.network.chat.Component_): void;
        setZ(z: number): void;
        setStatusMessage(message: net.minecraft.network.chat.Component_): void;
        getDistanceSq(pos: BlockPos_): number;
        changeDimension(p_20118_: Internal.ServerLevel_, teleporter: Internal.ITeleporter_): Internal.Entity;
        getAttachedOrElse<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        getProfile(): Internal.GameProfile;
        setHeadArmorItem(item: Internal.ItemStack_): void;
        getAttributeBaseValue(attribute: Internal.Attribute_): number;
        runCommand(command: string): number;
        set defaultMovementSpeedMultiplier(speed: number)
        get touchingUpsideDownFluid(): boolean
        get offHandItem(): Internal.ItemStack
        get player(): boolean
        get animal(): boolean
        set y(y: number)
        get living(): boolean
        get totalMovementSpeed(): number
        get customData(): Internal.CompoundTag
        get displayName(): net.minecraft.network.chat.Component
        set position(block: Internal.BlockContainerJS_)
        set motionZ(z: number)
        get teamId(): string
        set maxHealth(hp: number)
        get facing(): Internal.Direction
        get legsArmorItem(): Internal.ItemStack
        set mainHandItem(item: Internal.ItemStack_)
        get reachDistance(): number
        get motionX(): number
        get waterCreature(): boolean
        get item(): Internal.ItemStack
        set x(x: number)
        get potionEffects(): Internal.EntityPotionEffectsJS
        get frame(): boolean
        set legsArmorItem(item: Internal.ItemStack_)
        get defaultMovementSpeed(): number
        set motionY(y: number)
        get peacefulCreature(): boolean
        get undead(): boolean
        get dynamicLightEnabled(): boolean
        get ambientCreature(): boolean
        get monster(): boolean
        get type(): string
        set chestArmorItem(item: Internal.ItemStack_)
        get touchingFluid(): Internal.FluidState
        get block(): Internal.BlockContainerJS
        get nbt(): Internal.CompoundTag
        get motionY(): number
        get name(): net.minecraft.network.chat.Component
        get passengers(): Internal.EntityArrayList
        set totalMovementSpeedMultiplier(speed: number)
        get feetArmorItem(): Internal.ItemStack
        set defaultMovementSpeed(speed: number)
        set offHandItem(item: Internal.ItemStack_)
        get mainHandItem(): Internal.ItemStack
        get server(): Internal.MinecraftServer
        set motionX(x: number)
        set nbt(nbt: Internal.CompoundTag_)
        get level(): Internal.Level
        get scriptType(): Internal.ScriptType
        set movementSpeedAddition(speed: number)
        get headArmorItem(): Internal.ItemStack
        set dynamicLightEnabled(enabled: boolean)
        set feetArmorItem(item: Internal.ItemStack_)
        get chestArmorItem(): Internal.ItemStack
        get motionZ(): number
        set z(z: number)
        set statusMessage(message: net.minecraft.network.chat.Component_)
        get profile(): Internal.GameProfile
        set headArmorItem(item: Internal.ItemStack_)
    }
    type Evoker_ = Evoker;
    class Tank extends Internal.FluidTank {
        constructor(capacity: number, validator: Internal.Predicate_<dev.architectury.fluid.FluidStack>)
        constructor(capacity: number)
        readFromNBT(nbt: Internal.CompoundTag_, key: string): Internal.FluidTank;
        setCapacity(capacity: number): this;
        setSendUpdates(sendUpdates: boolean): void;
        setChange(changed: Internal.Runnable_): this;
        getPlatformWrapper(): any;
        onContentsChanged(): void;
        validate(validator: Internal.Predicate_<dev.architectury.fluid.FluidStack>): this;
        writeToNBT(nbt: Internal.CompoundTag_, key: string): Internal.CompoundTag;
        set capacity(capacity: number)
        set sendUpdates(sendUpdates: boolean)
        set change(changed: Internal.Runnable_)
        get platformWrapper(): any
    }
    type Tank_ = Tank;
    abstract class PropertyType <T extends Internal.PropertyType<T>> extends Internal.AbstractProperty<T> {
        constructor()
        static wrapNonNull(inner: Internal.PropertyType_<any>): Internal.PropertyType<any>;
        abstract getTypeName(): string;
        abstract fromJava(arg0: Internal.ITypeInfo_): void;
        abstract equalsToJavaType(arg0: Internal.ITypeInfo_): boolean;
        abstract typeEquals(arg0: T): boolean;
        static getClazzName(type: Internal.PropertyType_<any>): Internal.Optional<string>;
        get typeName(): string
    }
    type PropertyType_<T extends Internal.PropertyType<T>> = PropertyType<T>;
    class PlayerHeadItem extends Internal.StandingAndWallBlockItem {
        constructor($$0: Internal.Block_, $$1: Internal.Block_, $$2: Internal.Item$Properties_)
        hasCustomEntity(stack: Internal.ItemStack_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        allowContinuingBlockBreaking(player: Internal.Player_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getRecipeRemainder(stack: Internal.ItemStack_): Internal.ItemStack;
        onArmorTick(stack: Internal.ItemStack_, level: Internal.Level_, player: Internal.Player_): void;
        setDigSpeed(speed: number): void;
        onItemUseFirst(stack: Internal.ItemStack_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        setAttackSpeed(attackSpeed: number): void;
        arch$registryName(): ResourceLocation;
        setAttackDamage(attackDamage: number): void;
        getAttributeModifiers(stack: Internal.ItemStack_, slot: Internal.EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        static port_lib$getPlayerPOVHitResult(level: Internal.Level_, player: Internal.Player_, fluidMode: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        arch$holder(): Internal.Holder<Internal.Item>;
        getMod(): string;
        static getBaseAttackDamageUUID(): Internal.UUID;
        createEntity(level: Internal.Level_, location: Internal.Entity_, stack: Internal.ItemStack_): Internal.Entity;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        getCreativeTab(): string;
        setArmorToughness(armorToughness: number): void;
        onDroppedByPlayer(stack: Internal.ItemStack_, player: Internal.Player_): boolean;
        allowNbtUpdateAnimation(player: Internal.Player_, hand: Internal.InteractionHand_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getDefaultTooltipHideFlags(stack: Internal.ItemStack_): number;
        getCreatorModId(itemStack: Internal.ItemStack_): string;
        emi(amount: number): Internal.EmiStack;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        emi(): Internal.EmiStack;
        isSuitableFor(stack: Internal.ItemStack_, state: Internal.BlockState_): boolean;
        onLeftClickEntity(stack: Internal.ItemStack_, player: Internal.Player_, entity: Internal.Entity_): boolean;
        getDigSpeed(): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(itemstack: Internal.ItemStack_, pos: BlockPos_, player: Internal.Player_): boolean;
        removeFromBlockToItemMap(blockToItemMap: Internal.Map_<Internal.Block, Internal.Item>, itemIn: Internal.Item_): void;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        set attackDamage(attackDamage: number)
        get mod(): string
        get baseAttackDamageUUID(): Internal.UUID
        set armorProtection(armorProtection: number)
        get creativeTab(): string
        set armorToughness(armorToughness: number)
        get digSpeed(): number
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
        static readonly TAG_SKULL_OWNER: "SkullOwner";
    }
    type PlayerHeadItem_ = PlayerHeadItem;
    abstract class Dictionary <K, V> {
        constructor()
        abstract keys(): Internal.Enumeration<K>;
        abstract size(): number;
        abstract put(arg0: K, arg1: V): V;
        abstract get(arg0: any): V;
        abstract isEmpty(): boolean;
        abstract remove(arg0: any): V;
        abstract elements(): Internal.Enumeration<V>;
        get empty(): boolean
    }
    type Dictionary_<K, V> = Dictionary<K, V>;
    interface TransferVariant <O> {
        abstract getNbt(): Internal.CompoundTag;
        hasNbt(): boolean;
        abstract toNbt(): Internal.CompoundTag;
        abstract toPacket(arg0: Internal.FriendlyByteBuf_): void;
        copyNbt(): Internal.CompoundTag;
        copyOrCreateNbt(): Internal.CompoundTag;
        isOf(object: O): boolean;
        abstract isBlank(): boolean;
        abstract getObject(): O;
        nbtMatches(other: Internal.CompoundTag_): boolean;
        get nbt(): Internal.CompoundTag
        get blank(): boolean
        get object(): O
    }
    type TransferVariant_<O> = TransferVariant<O>;
    class Throwable implements Internal.Serializable {
        constructor()
        constructor(arg0: string, arg1: Internal.Throwable_)
        constructor(arg0: Internal.Throwable_)
        constructor(arg0: string)
        printStackTrace(arg0: Internal.PrintWriter_): void;
        getSuppressed(): Internal.Throwable[];
        fillInStackTrace(): this;
        getMessage(): string;
        addSuppressed(arg0: Internal.Throwable_): void;
        printStackTrace(): void;
        initCause(arg0: Internal.Throwable_): this;
        setStackTrace(arg0: Internal.StackTraceElement_[]): void;
        printStackTrace(arg0: Internal.PrintStream_): void;
        getCause(): this;
        getLocalizedMessage(): string;
        getStackTrace(): Internal.StackTraceElement[];
        get suppressed(): Internal.Throwable[]
        get message(): string
        set stackTrace(arg0: Internal.StackTraceElement_[])
        get cause(): Internal.Throwable
        get localizedMessage(): string
        get stackTrace(): Internal.StackTraceElement[]
    }
    type Throwable_ = Throwable;
    abstract class ExcavatingRecipeJS <T extends Internal.ExcavatingRecipeJS<T>> extends Internal.RecipeJS {
        constructor()
        stress(stress: number): T;
        priority(priority: number): T;
        drill(drill: InputItem_): T;
        getMod(): string;
        fluid(fluid: Internal.FluidStackJS_): T;
        get mod(): string
    }
    type ExcavatingRecipeJS_<T extends Internal.ExcavatingRecipeJS<T>> = ExcavatingRecipeJS<T>;
    class SmokingUpgradeItem extends Internal.UpgradeItemBase<Internal.CookingUpgradeWrapper$SmokingUpgradeWrapper> implements Internal.ICookingUpgradeItem {
        constructor(smokingUpgradeConfig: Internal.CookingUpgradeConfig_, upgradeTypeLimitConfig: any_)
        getCookingUpgradeConfig(): Internal.CookingUpgradeConfig;
        hasCustomEntity(stack: Internal.ItemStack_): boolean;
        getType(): Internal.UpgradeType<Internal.CookingUpgradeWrapper$SmokingUpgradeWrapper>;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        allowContinuingBlockBreaking(player: Internal.Player_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getRecipeRemainder(stack: Internal.ItemStack_): Internal.ItemStack;
        onArmorTick(stack: Internal.ItemStack_, level: Internal.Level_, player: Internal.Player_): void;
        setDigSpeed(speed: number): void;
        onItemUseFirst(stack: Internal.ItemStack_, context: Internal.UseOnContext_): Internal.InteractionResult;
        checkThisForConflictsWithExistingUpgrades(upgradeStack: Internal.ItemStack_, storageWrapper: Internal.IStorageWrapper_, excludeUpgradeSlot: number): Internal.UpgradeSlotChangeResult;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        canRemoveUpgradeFrom(storageWrapper: Internal.IStorageWrapper_, isClientSide: boolean, player: Internal.Player_): Internal.UpgradeSlotChangeResult;
        setAttackSpeed(attackSpeed: number): void;
        getCleanedUpgradeStack(upgradeStack: Internal.ItemStack_): Internal.ItemStack;
        arch$registryName(): ResourceLocation;
        setAttackDamage(attackDamage: number): void;
        getAttributeModifiers(stack: Internal.ItemStack_, slot: Internal.EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        static port_lib$getPlayerPOVHitResult(level: Internal.Level_, player: Internal.Player_, fluidMode: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        arch$holder(): Internal.Holder<Internal.Item>;
        getMod(): string;
        static getBaseAttackDamageUUID(): Internal.UUID;
        createEntity(level: Internal.Level_, location: Internal.Entity_, stack: Internal.ItemStack_): Internal.Entity;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        getInventoryColumnsTaken(): number;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        getCreativeTab(): string;
        setArmorToughness(armorToughness: number): void;
        onDroppedByPlayer(stack: Internal.ItemStack_, player: Internal.Player_): boolean;
        canSwapUpgradeFor(upgradeStackToPut: Internal.ItemStack_, upgradeSlot: number, storageWrapper: Internal.IStorageWrapper_, isClientSide: boolean): Internal.UpgradeSlotChangeResult;
        allowNbtUpdateAnimation(player: Internal.Player_, hand: Internal.InteractionHand_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        checkExtraInsertConditions(upgradeStack: Internal.ItemStack_, storageWrapper: Internal.IStorageWrapper_, isClientSide: boolean, upgradeInSlot: Internal.IUpgradeItem_<any>): Internal.UpgradeSlotChangeResult;
        getDefaultTooltipHideFlags(stack: Internal.ItemStack_): number;
        getCreatorModId(itemStack: Internal.ItemStack_): string;
        canAddUpgradeTo(storageWrapper: Internal.IStorageWrapper_, upgradeStack: Internal.ItemStack_, firstLevelStorage: boolean, isClientSide: boolean): Internal.UpgradeSlotChangeResult;
        emi(amount: number): Internal.EmiStack;
        canRemoveUpgradeFrom(storageWrapper: Internal.IStorageWrapper_, isClientSide: boolean): Internal.UpgradeSlotChangeResult;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        emi(): Internal.EmiStack;
        isSuitableFor(stack: Internal.ItemStack_, state: Internal.BlockState_): boolean;
        onLeftClickEntity(stack: Internal.ItemStack_, player: Internal.Player_, entity: Internal.Entity_): boolean;
        getDigSpeed(): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(itemstack: Internal.ItemStack_, pos: BlockPos_, player: Internal.Player_): boolean;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        get cookingUpgradeConfig(): Internal.CookingUpgradeConfig
        get type(): Internal.UpgradeType<Internal.CookingUpgradeWrapper$SmokingUpgradeWrapper>
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        set attackDamage(attackDamage: number)
        get mod(): string
        get baseAttackDamageUUID(): Internal.UUID
        get inventoryColumnsTaken(): number
        set armorProtection(armorProtection: number)
        get creativeTab(): string
        set armorToughness(armorToughness: number)
        get digSpeed(): number
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
        static readonly TYPE: Internal.UpgradeType<Internal.CookingUpgradeWrapper$SmokingUpgradeWrapper>;
    }
    type SmokingUpgradeItem_ = SmokingUpgradeItem;
    class GenericStack extends Internal.Record {
        constructor(what: Internal.AEKey_, amount: number)
        static wrapInItemStack(what: Internal.AEKey_, amount: number): Internal.ItemStack;
        static isWrapped(stack: Internal.ItemStack_): boolean;
        what(): Internal.AEKey;
        amount(): number;
        static readBuffer(buffer: Internal.FriendlyByteBuf_): Internal.GenericStack;
        static fromItemStack(stack: Internal.ItemStack_): Internal.GenericStack;
        static unwrapItemStack(stack: Internal.ItemStack_): Internal.GenericStack;
        static wrapInItemStack(stack: Internal.GenericStack_): Internal.ItemStack;
        static readTag(tag: Internal.CompoundTag_): Internal.GenericStack;
        static getStackSizeOrZero(stack: Internal.GenericStack_): number;
        static writeTag(stack: Internal.GenericStack_): Internal.CompoundTag;
        static sum(left: Internal.GenericStack_, right: Internal.GenericStack_): Internal.GenericStack;
        static writeBuffer(stack: Internal.GenericStack_, buffer: Internal.FriendlyByteBuf_): void;
    }
    type GenericStack_ = GenericStack;
    interface CustomValue$CvArray extends Internal.Iterable<Internal.CustomValue>, Internal.CustomValue {
        abstract size(): number;
        abstract get(arg0: number): Internal.CustomValue;
        abstract getAsString(): string;
        spliterator(): Internal.Spliterator<Internal.CustomValue>;
        forEach(arg0: Internal.Consumer_<Internal.CustomValue>): void;
        abstract getType(): Internal.CustomValue$CvType;
        abstract getAsNumber(): number;
        abstract getAsArray(): this;
        abstract iterator(): Internal.Iterator<Internal.CustomValue>;
        abstract getAsObject(): Internal.CustomValue$CvObject;
        abstract getAsBoolean(): boolean;
        get asString(): string
        get type(): Internal.CustomValue$CvType
        get asNumber(): number
        get asArray(): Internal.CustomValue$CvArray
        get asObject(): Internal.CustomValue$CvObject
        get asBoolean(): boolean
    }
    type CustomValue$CvArray_ = CustomValue$CvArray;
    class FacadePart implements Internal.IFacadePart {
        constructor(facade: Internal.ItemStack_, side: Internal.Direction_)
        getTextureItem(): Internal.ItemStack;
        getBlockState(): Internal.BlockState;
        getBoxes(ch: Internal.IPartCollisionHelper_, itemEntity: boolean): void;
        getItem(): Internal.Item;
        getSide(): Internal.Direction;
        getItemStack(): Internal.ItemStack;
        get textureItem(): Internal.ItemStack
        get blockState(): Internal.BlockState
        get item(): Internal.Item
        get side(): Internal.Direction
        get itemStack(): Internal.ItemStack
    }
    type FacadePart_ = FacadePart;
    class ChunkSkyLightSources {
        constructor($$0: Internal.LevelHeightAccessor_)
        getLowestSourceY($$0: number, $$1: number): number;
        update($$0: Internal.BlockGetter_, $$1: number, $$2: number, $$3: number): boolean;
        getHighestLowestSourceY(): number;
        fillFrom($$0: Internal.ChunkAccess_): void;
        get highestLowestSourceY(): number
        static readonly NEGATIVE_INFINITY: -2147483648;
    }
    type ChunkSkyLightSources_ = ChunkSkyLightSources;
    abstract class AbstractModifierRecipe$Serializer <T extends Internal.AbstractModifierRecipe> extends Internal.LoggingRecipeSerializer<T> {
        constructor()
        abstract fromNetwork(arg0: ResourceLocation_, arg1: Internal.FriendlyByteBuf_, arg2: Internal.Ingredient_, arg3: number, arg4: Internal.ModifierMatch_, arg5: string, arg6: Internal.ModifierEntry_, arg7: number, arg8: Internal.SlotType$SlotCount_): T;
        static register<S extends Internal.RecipeSerializer<T>, T extends Internal.Recipe<any>>($$0: string, $$1: S): S;
        fromJson(id: ResourceLocation_, json: Internal.JsonObject_): T;
        fromJson(arg0: ResourceLocation_, arg1: Internal.JsonObject_): Internal.Recipe<any>;
        abstract fromJson(arg0: ResourceLocation_, arg1: Internal.JsonObject_, arg2: Internal.Ingredient_, arg3: number, arg4: Internal.ModifierMatch_, arg5: string, arg6: Internal.ModifierEntry_, arg7: number, arg8: Internal.SlotType$SlotCount_): T;
    }
    type AbstractModifierRecipe$Serializer_<T extends Internal.AbstractModifierRecipe> = AbstractModifierRecipe$Serializer<T>;
    interface InjectedRegistryEntryExtension <T> {
        abstract arch$holder(): Internal.Holder<T>;
        arch$registryName(): ResourceLocation;
        (): Internal.Holder_<T>;
    }
    type InjectedRegistryEntryExtension_<T> = InjectedRegistryEntryExtension<T>;
    interface StickToBlock {
        canStickTo(state: Internal.BlockState_, other: Internal.BlockState_): boolean;
    }
    type StickToBlock_ = StickToBlock;
    class ServerboundPlayerAbilitiesPacket implements Internal.Packet<Internal.ServerGamePacketListener> {
        constructor($$0: Internal.FriendlyByteBuf_)
        constructor($$0: Internal.Abilities_)
        handle(arg0: Internal.PacketListener_): void;
        write($$0: Internal.FriendlyByteBuf_): void;
        handle($$0: Internal.ServerGamePacketListener_): void;
        isSkippable(): boolean;
        isFlying(): boolean;
        get skippable(): boolean
        get flying(): boolean
    }
    type ServerboundPlayerAbilitiesPacket_ = ServerboundPlayerAbilitiesPacket;
    interface Encoder <A> {
        encodeStart<T>(arg0: Internal.DynamicOps_<T>, arg1: A): Internal.DataResult<T>;
        fieldOf(arg0: string): Internal.MapEncoder<A>;
        empty<A>(): Internal.MapEncoder<A>;
        comap<B>(arg0: Internal.Function_<B, A>): Internal.Encoder<B>;
        error<A>(arg0: string): this;
        withLifecycle(arg0: Internal.Lifecycle_): this;
        flatComap<B>(arg0: Internal.Function_<B, Internal.DataResult<A>>): Internal.Encoder<B>;
        abstract encode<T>(arg0: A, arg1: Internal.DynamicOps_<T>, arg2: T): Internal.DataResult<T>;
        (arg0: A, arg1: Internal.DynamicOps<T>, arg2: T): Internal.DataResult_<T>;
    }
    type Encoder_<A> = Encoder<A>;
    abstract class Direction$Axis extends Internal.Enum<Internal.Direction$Axis> implements Internal.Predicate<Internal.Direction>, Internal.StringRepresentable {
        getPlane(): Internal.Direction$Plane;
        static not<T>(arg0: Internal.Predicate_<T>): Internal.Predicate<T>;
        static values(): Internal.Direction$Axis[];
        isVertical(): boolean;
        or(arg0: Internal.Predicate_<Internal.Direction>): Internal.Predicate<Internal.Direction>;
        static byName($$0: string): Internal.Direction$Axis;
        static fromEnumWithMapping<E extends Internal.Enum<E> & Internal.StringRepresentable>($$0: Internal.Supplier_<E[]>, $$1: Internal.Function_<string, string>): Internal.StringRepresentable$EnumCodec<E>;
        and(arg0: Internal.Predicate_<Internal.Direction>): Internal.Predicate<Internal.Direction>;
        getSerializedName(): string;
        isHorizontal(): boolean;
        static isEqual<T>(arg0: any): Internal.Predicate<T>;
        static getRandom($$0: Internal.RandomSource_): Internal.Direction$Axis;
        test(arg0: any): boolean;
        static fromEnum<E extends Internal.Enum<E> & Internal.StringRepresentable>($$0: Internal.Supplier_<E[]>): Internal.StringRepresentable$EnumCodec<E>;
        static keys($$0: Internal.StringRepresentable_[]): Internal.Keyable;
        static valueOf($$0: string): Internal.Direction$Axis;
        abstract choose(arg0: number, arg1: number, arg2: number): number;
        getName(): string;
        abstract choose(arg0: number, arg1: number, arg2: number): number;
        test($$0: Internal.Direction_): boolean;
        negate(): Internal.Predicate<Internal.Direction>;
        get plane(): Internal.Direction$Plane
        get vertical(): boolean
        get serializedName(): string
        get horizontal(): boolean
        get name(): string
        static readonly CODEC: Internal.StringRepresentable$EnumCodec<Internal.Direction$Axis>;
        static readonly Z: Internal.Direction$Axis;
        static readonly VALUES: Internal.Direction$Axis[];
        static readonly Y: Internal.Direction$Axis;
        static readonly X: Internal.Direction$Axis;
    }
    type Direction$Axis_ = Direction$Axis | "z" | "y" | "x";
    class CookingBookCategory extends Internal.Enum<Internal.CookingBookCategory> implements Internal.StringRepresentable {
        static fromEnum<E extends Internal.Enum<E> & Internal.StringRepresentable>($$0: Internal.Supplier_<E[]>): Internal.StringRepresentable$EnumCodec<E>;
        static keys($$0: Internal.StringRepresentable_[]): Internal.Keyable;
        static fromEnumWithMapping<E extends Internal.Enum<E> & Internal.StringRepresentable>($$0: Internal.Supplier_<E[]>, $$1: Internal.Function_<string, string>): Internal.StringRepresentable$EnumCodec<E>;
        getSerializedName(): string;
        static values(): Internal.CookingBookCategory[];
        static valueOf($$0: string): Internal.CookingBookCategory;
        get serializedName(): string
        static readonly BLOCKS: Internal.CookingBookCategory;
        static readonly MISC: Internal.CookingBookCategory;
        static readonly FOOD: Internal.CookingBookCategory;
        static readonly CODEC: Internal.StringRepresentable$EnumCodec<Internal.CookingBookCategory>;
    }
    type CookingBookCategory_ = CookingBookCategory | "misc" | "food" | "blocks";
    class SimpleCookingSerializer <T extends Internal.AbstractCookingRecipe> implements Internal.RecipeSerializer<T> {
        constructor($$0: any_<T>, $$1: number)
        static register<S extends Internal.RecipeSerializer<T>, T extends Internal.Recipe<any>>($$0: string, $$1: S): S;
        fromJson($$0: ResourceLocation_, $$1: Internal.JsonObject_): T;
        fromJson(arg0: ResourceLocation_, arg1: Internal.JsonObject_): Internal.Recipe<any>;
        fromNetwork($$0: ResourceLocation_, $$1: Internal.FriendlyByteBuf_): T;
        toNetwork($$0: Internal.FriendlyByteBuf_, $$1: T): void;
        toNetwork(arg0: Internal.FriendlyByteBuf_, arg1: Internal.Recipe_<any>): void;
        fromNetwork(arg0: ResourceLocation_, arg1: Internal.FriendlyByteBuf_): Internal.Recipe<any>;
        readonly defaultCookingTime: number;
    }
    type SimpleCookingSerializer_<T extends Internal.AbstractCookingRecipe> = SimpleCookingSerializer<T>;
    class ResourceBundle$Control {
        getFallbackLocale(arg0: string, arg1: Internal.Locale_): Internal.Locale;
        getCandidateLocales(arg0: string, arg1: Internal.Locale_): Internal.List<Internal.Locale>;
        getFormats(arg0: string): Internal.List<string>;
        getTimeToLive(arg0: string, arg1: Internal.Locale_): number;
        newBundle(arg0: string, arg1: Internal.Locale_, arg2: string, arg3: Internal.ClassLoader_, arg4: boolean): Internal.ResourceBundle;
        static getControl(arg0: Internal.List_<string>): Internal.ResourceBundle$Control;
        needsReload(arg0: string, arg1: Internal.Locale_, arg2: string, arg3: Internal.ClassLoader_, arg4: Internal.ResourceBundle_, arg5: number): boolean;
        static getNoFallbackControl(arg0: Internal.List_<string>): Internal.ResourceBundle$Control;
        toBundleName(arg0: string, arg1: Internal.Locale_): string;
        toResourceName(arg0: string, arg1: string): string;
        static readonly FORMAT_CLASS: ["java.class"];
        static readonly TTL_NO_EXPIRATION_CONTROL: -2;
        static readonly FORMAT_DEFAULT: ["java.class", "java.properties"];
        static readonly TTL_DONT_CACHE: -1;
        static readonly FORMAT_PROPERTIES: ["java.properties"];
    }
    type ResourceBundle$Control_ = ResourceBundle$Control;
    class CanvasRugBlock extends Internal.Block {
        constructor(properties: Internal.BlockBehaviour$Properties_)
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        getBlockStates(): Internal.List<Internal.BlockState>;
        arch$holder(): Internal.Holder<Internal.Block>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        emi(amount: number): Internal.EmiStack;
        setRequiresTool(v: boolean): void;
        emi(): Internal.EmiStack;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        set destroySpeed(v: number)
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
    }
    type CanvasRugBlock_ = CanvasRugBlock;
    class CloudInABottleItem extends Internal.WearableArtifactItem {
        constructor()
        static jump(player: Internal.Player_): void;
        hasCustomEntity(stack: Internal.ItemStack_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        allowContinuingBlockBreaking(player: Internal.Player_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getRecipeRemainder(stack: Internal.ItemStack_): Internal.ItemStack;
        onArmorTick(stack: Internal.ItemStack_, level: Internal.Level_, player: Internal.Player_): void;
        setDigSpeed(speed: number): void;
        onItemUseFirst(stack: Internal.ItemStack_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        setAttackSpeed(attackSpeed: number): void;
        arch$registryName(): ResourceLocation;
        setAttackDamage(attackDamage: number): void;
        getAttributeModifiers(stack: Internal.ItemStack_, slot: Internal.EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        static port_lib$getPlayerPOVHitResult(level: Internal.Level_, player: Internal.Player_, fluidMode: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        arch$holder(): Internal.Holder<Internal.Item>;
        getMod(): string;
        static getBaseAttackDamageUUID(): Internal.UUID;
        createEntity(level: Internal.Level_, location: Internal.Entity_, stack: Internal.ItemStack_): Internal.Entity;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        getCreativeTab(): string;
        hasNonCosmeticEffects(): boolean;
        setArmorToughness(armorToughness: number): void;
        onDroppedByPlayer(stack: Internal.ItemStack_, player: Internal.Player_): boolean;
        allowNbtUpdateAnimation(player: Internal.Player_, hand: Internal.InteractionHand_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getDefaultTooltipHideFlags(stack: Internal.ItemStack_): number;
        getCreatorModId(itemStack: Internal.ItemStack_): string;
        static getReducedFallDistance(entity: Internal.LivingEntity_, distance: number): number;
        emi(amount: number): Internal.EmiStack;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        emi(): Internal.EmiStack;
        isSuitableFor(stack: Internal.ItemStack_, state: Internal.BlockState_): boolean;
        onLeftClickEntity(stack: Internal.ItemStack_, player: Internal.Player_, entity: Internal.Entity_): boolean;
        getDigSpeed(): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(itemstack: Internal.ItemStack_, pos: BlockPos_, player: Internal.Player_): boolean;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        set attackDamage(attackDamage: number)
        get mod(): string
        get baseAttackDamageUUID(): Internal.UUID
        set armorProtection(armorProtection: number)
        get creativeTab(): string
        set armorToughness(armorToughness: number)
        get digSpeed(): number
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
    }
    type CloudInABottleItem_ = CloudInABottleItem;
    interface BiConsumer <T, U> {
        abstract accept(arg0: T, arg1: U): void;
        andThen(arg0: Internal.BiConsumer_<T, U>): this;
        (arg0: T, arg1: U): void;
    }
    type BiConsumer_<T, U> = BiConsumer<T, U>;
    class PulleyBlock$RopeBlockBase extends Internal.Block implements Internal.BlockPickInteractionAware, Internal.SimpleWaterloggedBlock {
        constructor(properties: Internal.BlockBehaviour$Properties_)
        canPlaceLiquid($$0: Internal.BlockGetter_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.Fluid_): boolean;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        pickupBlock($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_): Internal.ItemStack;
        getPickupSound(): Internal.Optional<Internal.SoundEvent>;
        getBlockStates(): Internal.List<Internal.BlockState>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        setRequiresTool(v: boolean): void;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        getPickedStack(state: Internal.BlockState_, view: Internal.BlockGetter_, pos: BlockPos_, player: Internal.Player_, result: Internal.HitResult_): Internal.ItemStack;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        placeLiquid($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.FluidState_): boolean;
        arch$holder(): Internal.Holder<Internal.Block>;
        emi(amount: number): Internal.EmiStack;
        emi(): Internal.EmiStack;
        get pickupSound(): Internal.Optional<Internal.SoundEvent>
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        set destroySpeed(v: number)
    }
    type PulleyBlock$RopeBlockBase_ = PulleyBlock$RopeBlockBase;
    class Triplet <L, M, R> extends Internal.Record {
        constructor(left: L, middle: M, right: R)
        middle(): M;
        static of<A, B, C>(left: A, middle: B, right: C): Internal.Triplet<A, B, C>;
        left(): L;
        right(): R;
    }
    type Triplet_<L, M, R> = Triplet<L, M, R>;
    interface MapCodec$ResultFunction <A> {
        abstract apply<T>(arg0: Internal.DynamicOps_<T>, arg1: Internal.MapLike_<T>, arg2: Internal.DataResult_<A>): Internal.DataResult<A>;
        abstract coApply<T>(arg0: Internal.DynamicOps_<T>, arg1: A, arg2: Internal.RecordBuilder_<T>): Internal.RecordBuilder<T>;
    }
    type MapCodec$ResultFunction_<A> = MapCodec$ResultFunction<A>;
    interface AccessorTrackTargetingBehavior {
        abstract setId(arg0: Internal.UUID_): void;
        abstract getTargetDirection(): Internal.Direction$AxisDirection;
        abstract getTargetTrack(): BlockPos;
        abstract setPrevDirection(arg0: Vec3d_): void;
        abstract setMigrationData(arg0: Internal.CompoundTag_): void;
        abstract setTargetBezier(arg0: Internal.BezierTrackPointLocation_): void;
        abstract setOrthogonal(arg0: boolean): void;
        abstract setTargetTrack(arg0: BlockPos_): void;
        abstract setEdgePoint(arg0: Internal.TrackEdgePoint_): void;
        abstract getMigrationData(): Internal.CompoundTag;
        abstract getPrevDirection(): Vec3d;
        abstract getId(): Internal.UUID;
        abstract setTargetDirection(arg0: Internal.Direction$AxisDirection_): void;
        abstract getTargetBezier(): Internal.BezierTrackPointLocation;
        abstract setRotatedDirection(arg0: Vec3d_): void;
        abstract isOrthogonal(): boolean;
        abstract getRotatedDirection(): Vec3d;
        set id(arg0: Internal.UUID_)
        get targetDirection(): Internal.Direction$AxisDirection
        get targetTrack(): BlockPos
        set prevDirection(arg0: Vec3d_)
        set migrationData(arg0: Internal.CompoundTag_)
        set targetBezier(arg0: Internal.BezierTrackPointLocation_)
        set orthogonal(arg0: boolean)
        set targetTrack(arg0: BlockPos_)
        set edgePoint(arg0: Internal.TrackEdgePoint_)
        get migrationData(): Internal.CompoundTag
        get prevDirection(): Vec3d
        get id(): Internal.UUID
        set targetDirection(arg0: Internal.Direction$AxisDirection_)
        get targetBezier(): Internal.BezierTrackPointLocation
        set rotatedDirection(arg0: Vec3d_)
        get orthogonal(): boolean
        get rotatedDirection(): Vec3d
    }
    type AccessorTrackTargetingBehavior_ = AccessorTrackTargetingBehavior;
    class SwordItemBuilder extends Internal.HandheldItemBuilder {
        constructor(i: ResourceLocation_)
        createObject(): Internal.Item;
    }
    type SwordItemBuilder_ = SwordItemBuilder;
    class TinkerStationDamagingRecipe$Serializer extends Internal.AbstractRecipeSerializer<Internal.TinkerStationDamagingRecipe> {
        constructor()
        static register<S extends Internal.RecipeSerializer<T>, T extends Internal.Recipe<any>>($$0: string, $$1: S): S;
        fromJson(arg0: ResourceLocation_, arg1: Internal.JsonObject_): Internal.Recipe<any>;
        fromJson(id: ResourceLocation_, json: Internal.JsonObject_): Internal.TinkerStationDamagingRecipe;
        fromNetwork(id: ResourceLocation_, buffer: Internal.FriendlyByteBuf_): Internal.TinkerStationDamagingRecipe;
        toNetwork(buffer: Internal.FriendlyByteBuf_, recipe: Internal.TinkerStationDamagingRecipe_): void;
        fromNetwork(arg0: ResourceLocation_, arg1: Internal.FriendlyByteBuf_): Internal.Recipe<any>;
    }
    type TinkerStationDamagingRecipe$Serializer_ = TinkerStationDamagingRecipe$Serializer;
    abstract class DiodeBlock extends Internal.HorizontalDirectionalBlock {
        shouldPrioritize($$0: Internal.BlockGetter_, $$1: BlockPos_, $$2: Internal.BlockState_): boolean;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        getBlockStates(): Internal.List<Internal.BlockState>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        static isDiode($$0: Internal.BlockState_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        setRequiresTool(v: boolean): void;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        arch$holder(): Internal.Holder<Internal.Block>;
        emi(amount: number): Internal.EmiStack;
        isLocked($$0: Internal.LevelReader_, $$1: BlockPos_, $$2: Internal.BlockState_): boolean;
        emi(): Internal.EmiStack;
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        set destroySpeed(v: number)
        static readonly POWERED: Internal.BooleanProperty;
    }
    type DiodeBlock_ = DiodeBlock;
    class SimplePacketBase$NetworkDirection extends Internal.Enum<Internal.SimplePacketBase$NetworkDirection> {
        static valueOf(name: string): Internal.SimplePacketBase$NetworkDirection;
        static values(): Internal.SimplePacketBase$NetworkDirection[];
        static readonly PLAY_TO_CLIENT: Internal.SimplePacketBase$NetworkDirection;
        static readonly PLAY_TO_SERVER: Internal.SimplePacketBase$NetworkDirection;
    }
    type SimplePacketBase$NetworkDirection_ = "play_to_server" | "play_to_client" | SimplePacketBase$NetworkDirection;
    class MushroomColonyItem extends Internal.BlockItem {
        constructor(blockIn: Internal.Block_, properties: Internal.Item$Properties_)
        hasCustomEntity(stack: Internal.ItemStack_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        allowContinuingBlockBreaking(player: Internal.Player_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getRecipeRemainder(stack: Internal.ItemStack_): Internal.ItemStack;
        onArmorTick(stack: Internal.ItemStack_, level: Internal.Level_, player: Internal.Player_): void;
        setDigSpeed(speed: number): void;
        onItemUseFirst(stack: Internal.ItemStack_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        setAttackSpeed(attackSpeed: number): void;
        arch$registryName(): ResourceLocation;
        setAttackDamage(attackDamage: number): void;
        getAttributeModifiers(stack: Internal.ItemStack_, slot: Internal.EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        static port_lib$getPlayerPOVHitResult(level: Internal.Level_, player: Internal.Player_, fluidMode: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        arch$holder(): Internal.Holder<Internal.Item>;
        getMod(): string;
        static getBaseAttackDamageUUID(): Internal.UUID;
        createEntity(level: Internal.Level_, location: Internal.Entity_, stack: Internal.ItemStack_): Internal.Entity;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        getCreativeTab(): string;
        setArmorToughness(armorToughness: number): void;
        onDroppedByPlayer(stack: Internal.ItemStack_, player: Internal.Player_): boolean;
        allowNbtUpdateAnimation(player: Internal.Player_, hand: Internal.InteractionHand_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getDefaultTooltipHideFlags(stack: Internal.ItemStack_): number;
        getCreatorModId(itemStack: Internal.ItemStack_): string;
        emi(amount: number): Internal.EmiStack;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        emi(): Internal.EmiStack;
        isSuitableFor(stack: Internal.ItemStack_, state: Internal.BlockState_): boolean;
        onLeftClickEntity(stack: Internal.ItemStack_, player: Internal.Player_, entity: Internal.Entity_): boolean;
        getDigSpeed(): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(itemstack: Internal.ItemStack_, pos: BlockPos_, player: Internal.Player_): boolean;
        removeFromBlockToItemMap(blockToItemMap: Internal.Map_<Internal.Block, Internal.Item>, itemIn: Internal.Item_): void;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        set attackDamage(attackDamage: number)
        get mod(): string
        get baseAttackDamageUUID(): Internal.UUID
        set armorProtection(armorProtection: number)
        get creativeTab(): string
        set armorToughness(armorToughness: number)
        get digSpeed(): number
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
    }
    type MushroomColonyItem_ = MushroomColonyItem;
    abstract class Animal extends Internal.AgeableMob {
        getDistance(pos: BlockPos_): number;
        splitIntoDynamicLightEntries(cellHasher: Internal.CellHasher_): Internal.Stream<Internal.SpatialLookupEntry>;
        canMate($$0: Internal.Animal_): boolean;
        damageHeldItem(hand: Internal.InteractionHand_, amount: number): void;
        removeAttribute(attribute: Internal.Attribute_, identifier: string): void;
        playSound(id: Internal.SoundEvent_, volume: number, pitch: number): void;
        static port_lib$collideWithShapes(vec3: Vec3d_, aABB: Internal.AABB_, list: Internal.List_<Internal.VoxelShape>): Vec3d;
        damageEquipment(slot: Internal.EquipmentSlot_, amount: number, onBroken: Internal.Consumer_<Internal.ItemStack>): void;
        setDefaultMovementSpeedMultiplier(speed: number): void;
        method_5992($$0: Internal.Player_, $$1: Internal.InteractionHand_): Internal.InteractionResult;
        isTouchingUpsideDownFluid(): boolean;
        getOffHandItem(): Internal.ItemStack;
        isOnScoreboardTeam(teamId: string): boolean;
        getAttachedOrSet<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        getEquipment(slot: Internal.EquipmentSlot_): Internal.ItemStack;
        removeAttached<A>(type: Internal.AttachmentType_<A>): A;
        swing(): void;
        setPosition(x: number, y: number, z: number): void;
        runCommandSilent(command: string): number;
        isPlayer(): boolean;
        isAnimal(): boolean;
        getInLoveTime(): number;
        rayTrace(distance: number, fluids: boolean): Internal.RayTraceResultJS;
        asComponentProvider(): Internal.ComponentProvider;
        setY(y: number): void;
        isLiving(): boolean;
        damageEquipment(slot: Internal.EquipmentSlot_): void;
        static tickEntity(entity: Internal.Entity_): void;
        static transfer(original: Internal.AttachmentTarget_, target: Internal.AttachmentTarget_, isDeath: boolean): void;
        rayTrace(): Internal.RayTraceResultJS;
        getTotalMovementSpeed(): number;
        alwaysAccepts(): boolean;
        getCustomData(): Internal.CompoundTag;
        damageHeldItem(): void;
        getDisplayName(): net.minecraft.network.chat.Component;
        setPosition(block: Internal.BlockContainerJS_): void;
        setMotionZ(z: number): void;
        mergeNbt(tag: Internal.CompoundTag_): Internal.Entity;
        attack(hp: number): void;
        lambdynlights$scheduleTrackedChunksRebuild(renderer: Internal.LevelRenderer_): void;
        getTeamId(): string;
        setMaxHealth(hp: number): void;
        isFood($$0: Internal.ItemStack_): boolean;
        getFacing(): Internal.Direction;
        canRiderInteract(): boolean;
        spawnChildFromBreeding($$0: Internal.ServerLevel_, $$1: Internal.Animal_): void;
        setInLoveTime($$0: number): void;
        getLegsArmorItem(): Internal.ItemStack;
        setMainHandItem(item: Internal.ItemStack_): void;
        isHoldingInAnyHand(i: Internal.Ingredient_): boolean;
        captureDrops(value: Internal.Collection_<Internal.ItemEntity>): Internal.Collection<Internal.ItemEntity>;
        rayTrace(distance: number): Internal.RayTraceResultJS;
        getReachDistance(): number;
        getMotionX(): number;
        isWaterCreature(): boolean;
        isInLove(): boolean;
        getItem(): Internal.ItemStack;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_, predicate: Internal.PlayerSyncPredicate_): void;
        setX(x: number): void;
        setAttributeBaseValue(attribute: Internal.Attribute_, value: number): void;
        getDynamicLightChunksToRebuild(forced: boolean): Internal.LongSet;
        getPotionEffects(): Internal.EntityPotionEffectsJS;
        isFrame(): boolean;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>, initializer: Internal.Supplier_<A>): A;
        setLegsArmorItem(item: Internal.ItemStack_): void;
        playSound(id: Internal.SoundEvent_): void;
        foodEaten(is: Internal.ItemStack_): void;
        getAttachedOrThrow<A>(type: Internal.AttachmentType_<A>): A;
        getDefaultMovementSpeed(): number;
        getHeldItem(hand: Internal.InteractionHand_): Internal.ItemStack;
        swing(hand: Internal.InteractionHand_): void;
        getDistance(x: number, y: number, z: number): number;
        setMotionY(y: number): void;
        getAttributeTotalValue(attribute: Internal.Attribute_): number;
        isPeacefulCreature(): boolean;
        syncComponent(key: Internal.ComponentKey_<any>): void;
        isUndead(): boolean;
        setRotation(yaw: number, pitch: number): void;
        modifyAttached<A>(type: Internal.AttachmentType_<A>, modifier: Internal.UnaryOperator_<A>): A;
        isDynamicLightEnabled(): boolean;
        isAmbientCreature(): boolean;
        isMonster(): boolean;
        canFallInLove(): boolean;
        getLoveCause(): Internal.ServerPlayer;
        getType(): string;
        static checkAnimalSpawnRules($$0: Internal.EntityType_<Internal.Animal>, $$1: Internal.LevelAccessor_, $$2: Internal.MobSpawnType_, $$3: BlockPos_, $$4: Internal.RandomSource_): boolean;
        self(): Internal.Entity;
        setChestArmorItem(item: Internal.ItemStack_): void;
        checkUpsideDownState(): void;
        getTouchingFluid(): Internal.FluidState;
        getBlock(): Internal.BlockContainerJS;
        getNbt(): Internal.CompoundTag;
        getComponent<C extends dev.onyxstudios.cca.api.v3.component.Component>(key: Internal.ComponentKey_<C>): C;
        setEquipment(slot: Internal.EquipmentSlot_, item: Internal.ItemStack_): void;
        getMotionY(): number;
        getName(): net.minecraft.network.chat.Component;
        getPassengers(): Internal.EntityArrayList;
        resetLove(): void;
        setTotalMovementSpeedMultiplier(speed: number): void;
        sophisticatedInvalidateCaps(): void;
        lithiumOnEquipmentChanged(): void;
        getAttachedOrGet<A>(type: Internal.AttachmentType_<A>, defaultValue: Internal.Supplier_<A>): A;
        setHeldItem(hand: Internal.InteractionHand_, item: Internal.ItemStack_): void;
        etf$getETFRenderState(): Internal.ETFEntityRenderState;
        damageHeldItem(hand: Internal.InteractionHand_, amount: number, onBroken: Internal.Consumer_<Internal.ItemStack>): void;
        getFeetArmorItem(): Internal.ItemStack;
        setDefaultMovementSpeed(speed: number): void;
        setOffHandItem(item: Internal.ItemStack_): void;
        getMainHandItem(): Internal.ItemStack;
        spawn(): void;
        getServer(): Internal.MinecraftServer;
        setMotionX(x: number): void;
        canEntityBeSeen(entity: Internal.LivingEntity_): boolean;
        teleportTo(dimension: ResourceLocation_, x: number, y: number, z: number, yaw: number, pitch: number): void;
        static gatherClosestChunks(chunks: Internal.LongSet_, x: number, y: number, z: number): void;
        captureDrops(): Internal.Collection<Internal.ItemEntity>;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>): A;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_): void;
        setNbt(nbt: Internal.CompoundTag_): void;
        getLevel(): Internal.Level;
        getScriptType(): Internal.ScriptType;
        setMovementSpeedAddition(speed: number): void;
        serializeNBT(): Internal.Tag;
        getHeadArmorItem(): Internal.ItemStack;
        modifyAttribute(attribute: Internal.Attribute_, identifier: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        setDynamicLightEnabled(enabled: boolean): void;
        setFeetArmorItem(item: Internal.ItemStack_): void;
        setPositionAndRotation(x: number, y: number, z: number, yaw: number, pitch: number): void;
        getChestArmorItem(): Internal.ItemStack;
        damageEquipment(slot: Internal.EquipmentSlot_, amount: number): void;
        getMotionZ(): number;
        lambdynlights$updateDynamicLight(renderer: Internal.LevelRenderer_): boolean;
        tell(message: net.minecraft.network.chat.Component_): void;
        setZ(z: number): void;
        setStatusMessage(message: net.minecraft.network.chat.Component_): void;
        getDistanceSq(pos: BlockPos_): number;
        finalizeSpawnChildFromBreeding($$0: Internal.ServerLevel_, $$1: Internal.Animal_, $$2: Internal.AgeableMob_): void;
        changeDimension(p_20118_: Internal.ServerLevel_, teleporter: Internal.ITeleporter_): Internal.Entity;
        getAttachedOrElse<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        getProfile(): Internal.GameProfile;
        setInLove($$0: Internal.Player_): void;
        setHeadArmorItem(item: Internal.ItemStack_): void;
        getAttributeBaseValue(attribute: Internal.Attribute_): number;
        runCommand(command: string): number;
        set defaultMovementSpeedMultiplier(speed: number)
        get touchingUpsideDownFluid(): boolean
        get offHandItem(): Internal.ItemStack
        get player(): boolean
        get animal(): boolean
        get inLoveTime(): number
        set y(y: number)
        get living(): boolean
        get totalMovementSpeed(): number
        get customData(): Internal.CompoundTag
        get displayName(): net.minecraft.network.chat.Component
        set position(block: Internal.BlockContainerJS_)
        set motionZ(z: number)
        get teamId(): string
        set maxHealth(hp: number)
        get facing(): Internal.Direction
        set inLoveTime($$0: number)
        get legsArmorItem(): Internal.ItemStack
        set mainHandItem(item: Internal.ItemStack_)
        get reachDistance(): number
        get motionX(): number
        get waterCreature(): boolean
        get inLove(): boolean
        get item(): Internal.ItemStack
        set x(x: number)
        get potionEffects(): Internal.EntityPotionEffectsJS
        get frame(): boolean
        set legsArmorItem(item: Internal.ItemStack_)
        get defaultMovementSpeed(): number
        set motionY(y: number)
        get peacefulCreature(): boolean
        get undead(): boolean
        get dynamicLightEnabled(): boolean
        get ambientCreature(): boolean
        get monster(): boolean
        get loveCause(): Internal.ServerPlayer
        get type(): string
        set chestArmorItem(item: Internal.ItemStack_)
        get touchingFluid(): Internal.FluidState
        get block(): Internal.BlockContainerJS
        get nbt(): Internal.CompoundTag
        get motionY(): number
        get name(): net.minecraft.network.chat.Component
        get passengers(): Internal.EntityArrayList
        set totalMovementSpeedMultiplier(speed: number)
        get feetArmorItem(): Internal.ItemStack
        set defaultMovementSpeed(speed: number)
        set offHandItem(item: Internal.ItemStack_)
        get mainHandItem(): Internal.ItemStack
        get server(): Internal.MinecraftServer
        set motionX(x: number)
        set nbt(nbt: Internal.CompoundTag_)
        get level(): Internal.Level
        get scriptType(): Internal.ScriptType
        set movementSpeedAddition(speed: number)
        get headArmorItem(): Internal.ItemStack
        set dynamicLightEnabled(enabled: boolean)
        set feetArmorItem(item: Internal.ItemStack_)
        get chestArmorItem(): Internal.ItemStack
        get motionZ(): number
        set z(z: number)
        set statusMessage(message: net.minecraft.network.chat.Component_)
        get profile(): Internal.GameProfile
        set inLove($$0: Internal.Player_)
        set headArmorItem(item: Internal.ItemStack_)
    }
    type Animal_ = Animal;
    class MaterialVariant extends Internal.LazyMaterial {
        getVariant(): Internal.MaterialVariantId;
        static of(material: Internal.IMaterial_): Internal.MaterialVariant;
        static of(id: Internal.MaterialId_, variant: string): Internal.MaterialVariant;
        matchesVariant(stack: Internal.ItemStack_): boolean;
        matchesVariant(variant: Internal.MaterialVariant_): boolean;
        matchesVariant(variantId: Internal.MaterialVariantId_): boolean;
        static of(material: Internal.IMaterial_, variant: string): Internal.MaterialVariant;
        sameVariant(variantId: Internal.MaterialVariantId_): boolean;
        static of(variantId: Internal.MaterialVariantId_): Internal.MaterialVariant;
        get variant(): Internal.MaterialVariantId
        static readonly UNKNOWN: Internal.MaterialVariant;
    }
    type MaterialVariant_ = MaterialVariant;
    class CACakeBlock extends Internal.CakeBlock {
        constructor(props: Internal.BlockBehaviour$Properties_)
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        getBlockStates(): Internal.List<Internal.BlockState>;
        arch$holder(): Internal.Holder<Internal.Block>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        emi(amount: number): Internal.EmiStack;
        setRequiresTool(v: boolean): void;
        emi(): Internal.EmiStack;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        set destroySpeed(v: number)
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
    }
    type CACakeBlock_ = CACakeBlock;
    class FletchingTableBlock extends Internal.CraftingTableBlock {
        constructor($$0: Internal.BlockBehaviour$Properties_)
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        getBlockStates(): Internal.List<Internal.BlockState>;
        arch$holder(): Internal.Holder<Internal.Block>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        emi(amount: number): Internal.EmiStack;
        setRequiresTool(v: boolean): void;
        emi(): Internal.EmiStack;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        set destroySpeed(v: number)
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
    }
    type FletchingTableBlock_ = FletchingTableBlock;
    interface Codec <A> extends Internal.Decoder<A>, Internal.Encoder<A> {
        optionalFieldOf(arg0: string, arg1: A): Internal.MapCodec<A>;
        empty<A>(): Internal.MapEncoder<A>;
        error<A>(arg0: string): Internal.Encoder<A>;
        unit<A>(arg0: Internal.Supplier_<A>): this;
        parse<T>(arg0: Internal.Dynamic_<T>): Internal.DataResult<A>;
        promotePartial(arg0: Internal.Consumer_<string>): this;
        flatComap<B>(arg0: Internal.Function_<B, Internal.DataResult<A>>): Internal.Encoder<B>;
        simple(): Internal.Decoder$Simple<A>;
        stable(): this;
        floatRange(arg0: number, arg1: number): Internal.Codec<number>;
        ofBoxed<A>(arg0: Internal.Decoder$Boxed_<A>): Internal.Decoder<A>;
        dispatch<E>(arg0: Internal.Function_<E, A>, arg1: Internal.Function_<A, Internal.Codec<E>>): Internal.Codec<E>;
        partialDispatch<E>(arg0: string, arg1: Internal.Function_<E, Internal.DataResult<A>>, arg2: Internal.Function_<A, Internal.DataResult<Internal.Codec<E>>>): Internal.Codec<E>;
        comap<B>(arg0: Internal.Function_<B, A>): Internal.Encoder<B>;
        withLifecycle(arg0: Internal.Lifecycle_): this;
        dispatchMap<E>(arg0: string, arg1: Internal.Function_<E, A>, arg2: Internal.Function_<A, Internal.Codec<E>>): Internal.MapCodec<E>;
        unit<A>(arg0: A): this;
        intRange(arg0: number, arg1: number): Internal.Codec<number>;
        orElseGet(arg0: Internal.Consumer_<string>, arg1: Internal.Supplier_<A>): this;
        orElse(arg0: Internal.UnaryOperator_<string>, arg1: A): this;
        pair<F, S>(arg0: Internal.Codec_<F>, arg1: Internal.Codec_<S>): Internal.Codec<com.mojang.datafixers.util.Pair<F, S>>;
        either<F, S>(arg0: Internal.Codec_<F>, arg1: Internal.Codec_<S>): Internal.Codec<Internal.Either<F, S>>;
        checkRange<N extends number & Internal.Comparable<N>>(arg0: N, arg1: N): Internal.Function<N, Internal.DataResult<N>>;
        optionalFieldOf(arg0: string): Internal.MapCodec<Internal.Optional<A>>;
        unboundedMap<K, V>(arg0: Internal.Codec_<K>, arg1: Internal.Codec_<V>): Internal.UnboundedMapCodec<K, V>;
        fieldOf(arg0: string): Internal.MapDecoder<any>;
        dispatchStable<E>(arg0: Internal.Function_<E, A>, arg1: Internal.Function_<A, Internal.Codec<E>>): Internal.Codec<E>;
        of<A>(arg0: Internal.Encoder_<A>, arg1: Internal.Decoder_<A>, arg2: string): this;
        optionalFieldOf(arg0: string, arg1: Internal.Lifecycle_, arg2: A, arg3: Internal.Lifecycle_): Internal.MapCodec<A>;
        parse<T>(arg0: Internal.DynamicOps_<T>, arg1: T): Internal.DataResult<A>;
        ofSimple<A>(arg0: Internal.Decoder$Simple_<A>): Internal.Decoder<A>;
        mapEither<F, S>(arg0: Internal.MapCodec_<F>, arg1: Internal.MapCodec_<S>): Internal.MapCodec<Internal.Either<F, S>>;
        doubleRange(arg0: number, arg1: number): Internal.Codec<number>;
        optionalField<F>(arg0: string, arg1: Internal.Codec_<F>): Internal.MapCodec<Internal.Optional<F>>;
        simpleMap<K, V>(arg0: Internal.Codec_<K>, arg1: Internal.Codec_<V>, arg2: Internal.Keyable_): Internal.SimpleMapCodec<K, V>;
        orElseGet(arg0: Internal.Supplier_<A>): this;
        ofTerminal<A>(arg0: Internal.Decoder$Terminal_<A>): Internal.Decoder<A>;
        map<B>(arg0: Internal.Function_<A, B>): Internal.Decoder<B>;
        orElse(arg0: A): this;
        deprecated(arg0: number): this;
        list<E>(arg0: Internal.Codec_<E>): Internal.Codec<Internal.List<E>>;
        dispatchMap<E>(arg0: Internal.Function_<E, A>, arg1: Internal.Function_<A, Internal.Codec<E>>): Internal.MapCodec<E>;
        flatMap<B>(arg0: Internal.Function_<A, Internal.DataResult<B>>): Internal.Decoder<B>;
        boxed(): Internal.Decoder$Boxed<A>;
        xmap<S>(arg0: Internal.Function_<A, S>, arg1: Internal.Function_<S, A>): Internal.Codec<S>;
        of<A>(arg0: Internal.MapEncoder_<A>, arg1: Internal.MapDecoder_<A>): Internal.MapCodec<A>;
        dispatch<E>(arg0: string, arg1: Internal.Function_<E, A>, arg2: Internal.Function_<A, Internal.Codec<E>>): Internal.Codec<E>;
        comapFlatMap<S>(arg0: Internal.Function_<A, Internal.DataResult<S>>, arg1: Internal.Function_<S, A>): Internal.Codec<S>;
        of<A>(arg0: Internal.Encoder_<A>, arg1: Internal.Decoder_<A>): this;
        orElseGet(arg0: Internal.UnaryOperator_<string>, arg1: Internal.Supplier_<A>): this;
        optionalFieldOf(arg0: string, arg1: A, arg2: Internal.Lifecycle_): Internal.MapCodec<A>;
        terminal(): Internal.Decoder$Terminal<A>;
        of<A>(arg0: Internal.MapEncoder_<A>, arg1: Internal.MapDecoder_<A>, arg2: Internal.Supplier_<string>): Internal.MapCodec<A>;
        orElse(arg0: Internal.Consumer_<string>, arg1: A): this;
        compoundList<K, V>(arg0: Internal.Codec_<K>, arg1: Internal.Codec_<V>): Internal.Codec<Internal.List<com.mojang.datafixers.util.Pair<K, V>>>;
        abstract decode<T>(arg0: Internal.DynamicOps_<T>, arg1: T): Internal.DataResult<com.mojang.datafixers.util.Pair<A, T>>;
        listOf(): Internal.Codec<Internal.List<A>>;
        encodeStart<T>(arg0: Internal.DynamicOps_<T>, arg1: A): Internal.DataResult<T>;
        flatXmap<S>(arg0: Internal.Function_<A, Internal.DataResult<S>>, arg1: Internal.Function_<S, Internal.DataResult<A>>): Internal.Codec<S>;
        decode<T>(arg0: Internal.Dynamic_<T>): Internal.DataResult<com.mojang.datafixers.util.Pair<A, T>>;
        flatComapMap<S>(arg0: Internal.Function_<A, S>, arg1: Internal.Function_<S, Internal.DataResult<A>>): Internal.Codec<S>;
        mapResult(arg0: Internal.Codec$ResultFunction_<A>): this;
        mapPair<F, S>(arg0: Internal.MapCodec_<F>, arg1: Internal.MapCodec_<S>): Internal.MapCodec<com.mojang.datafixers.util.Pair<F, S>>;
        abstract encode<T>(arg0: A, arg1: Internal.DynamicOps_<T>, arg2: T): Internal.DataResult<T>;
        readonly BOOL: Internal.PrimitiveCodec<boolean>;
        readonly DOUBLE: Internal.PrimitiveCodec<number>;
        readonly BYTE_BUFFER: Internal.PrimitiveCodec<Internal.ByteBuffer>;
        readonly INT: Internal.PrimitiveCodec<number>;
        readonly LONG_STREAM: Internal.PrimitiveCodec<Internal.LongStream>;
        readonly FLOAT: Internal.PrimitiveCodec<number>;
        readonly BYTE: Internal.PrimitiveCodec<number>;
        readonly EMPTY: Internal.MapCodec<com.mojang.datafixers.util.Unit>;
        readonly INT_STREAM: Internal.PrimitiveCodec<Internal.IntStream>;
        readonly LONG: Internal.PrimitiveCodec<number>;
        readonly SHORT: Internal.PrimitiveCodec<number>;
        readonly PASSTHROUGH: Internal.Codec<Internal.Dynamic<any>>;
        readonly STRING: Internal.PrimitiveCodec<string>;
    }
    type Codec_<A> = Codec<A>;
    class PackagerBlock extends Internal.WrenchableDirectionalBlock implements Internal.WeakPowerCheckingBlock, com.simibubi.create.content.equipment.wrench.IWrenchable, Internal.IBE<Internal.PackagerBlockEntity>, Internal.NeighborChangeListeningBlock {
        constructor(properties: Internal.BlockBehaviour$Properties_)
        onNeighborChange(state: Internal.BlockState_, level: Internal.LevelReader_, pos: BlockPos_, neighbor: BlockPos_): void;
        newBlockEntity(p_153215_: BlockPos_, p_153216_: Internal.BlockState_): Internal.BlockEntity;
        getBlockEntityOptional(world: Internal.BlockGetter_, pos: BlockPos_): Internal.Optional<Internal.PackagerBlockEntity>;
        withBlockEntityDo(world: Internal.BlockGetter_, pos: BlockPos_, action: Internal.Consumer_<Internal.PackagerBlockEntity>): void;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        static onRemove(blockState: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, newBlockState: Internal.BlockState_): void;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        getBlockStates(): Internal.List<Internal.BlockState>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        getBlockEntityType(): Internal.BlockEntityType<Internal.PackagerBlockEntity>;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        setRequiresTool(v: boolean): void;
        onBlockEntityUse(world: Internal.BlockGetter_, pos: BlockPos_, action: Internal.Function_<Internal.PackagerBlockEntity, Internal.InteractionResult>): Internal.InteractionResult;
        onSneakWrenched(state: Internal.BlockState_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        updateAfterWrenched(newState: Internal.BlockState_, context: Internal.UseOnContext_): Internal.BlockState;
        onWrenched(state: Internal.BlockState_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getRotatedBlockState(originalState: Internal.BlockState_, targetedFace: Internal.Direction_): Internal.BlockState;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        getBlockEntity(worldIn: Internal.BlockGetter_, pos: BlockPos_): Internal.PackagerBlockEntity;
        setDestroySpeed(v: number): void;
        static playRemoveSound(level: Internal.Level_, pos: BlockPos_): void;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        getBlockEntityClass(): typeof Internal.PackagerBlockEntity;
        shouldCheckWeakPower(state: Internal.BlockState_, level: Internal.SignalGetter_, pos: BlockPos_, side: Internal.Direction_): boolean;
        getListener<T extends Internal.BlockEntity>($$0: Internal.ServerLevel_, $$1: T): Internal.GameEventListener;
        arch$holder(): Internal.Holder<Internal.Block>;
        emi(amount: number): Internal.EmiStack;
        getTicker<S extends Internal.BlockEntity>(p_153212_: Internal.Level_, p_153213_: Internal.BlockState_, p_153214_: Internal.BlockEntityType_<S>): Internal.BlockEntityTicker<S>;
        static playRotateSound(level: Internal.Level_, pos: BlockPos_): void;
        emi(): Internal.EmiStack;
        get blockStates(): Internal.List<Internal.BlockState>
        get blockEntityType(): Internal.BlockEntityType<Internal.PackagerBlockEntity>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        set destroySpeed(v: number)
        get blockEntityClass(): typeof Internal.PackagerBlockEntity
        static readonly LINKED: Internal.BooleanProperty;
        static readonly POWERED: Internal.BooleanProperty;
    }
    type PackagerBlock_ = PackagerBlock;
    class BeehiveDecorator extends Internal.TreeDecorator {
        constructor($$0: number)
        static readonly CODEC: Internal.Codec<Internal.BeehiveDecorator>;
    }
    type BeehiveDecorator_ = BeehiveDecorator;
    interface Vector2dc {
        abstract equals(arg0: Internal.Vector2dc_, arg1: number): boolean;
        abstract get(arg0: number, arg1: Internal.ByteBuffer_): Internal.ByteBuffer;
        abstract mulTranspose(arg0: Internal.Matrix2fc_, arg1: Internal.Vector2d_): Internal.Vector2d;
        abstract add(arg0: number, arg1: number, arg2: Internal.Vector2d_): Internal.Vector2d;
        abstract fma(arg0: Internal.Vector2dc_, arg1: Internal.Vector2dc_, arg2: Internal.Vector2d_): Internal.Vector2d;
        abstract isFinite(): boolean;
        abstract get(arg0: Internal.Vector2d_): Internal.Vector2d;
        abstract distance(arg0: Internal.Vector2fc_): number;
        abstract distance(arg0: Internal.Vector2dc_): number;
        abstract mul(arg0: Internal.Matrix2fc_, arg1: Internal.Vector2d_): Internal.Vector2d;
        abstract getToAddress(arg0: number): this;
        abstract angle(arg0: Internal.Vector2dc_): number;
        abstract mul(arg0: number, arg1: Internal.Vector2d_): Internal.Vector2d;
        abstract div(arg0: number, arg1: Internal.Vector2d_): Internal.Vector2d;
        abstract add(arg0: Internal.Vector2fc_, arg1: Internal.Vector2d_): Internal.Vector2d;
        abstract get(arg0: Internal.DoubleBuffer_): Internal.DoubleBuffer;
        abstract x(): number;
        abstract equals(arg0: number, arg1: number): boolean;
        abstract absolute(arg0: Internal.Vector2d_): Internal.Vector2d;
        abstract dot(arg0: Internal.Vector2dc_): number;
        abstract sub(arg0: Internal.Vector2dc_, arg1: Internal.Vector2d_): Internal.Vector2d;
        abstract lerp(arg0: Internal.Vector2dc_, arg1: number, arg2: Internal.Vector2d_): Internal.Vector2d;
        abstract round(arg0: Internal.Vector2d_): Internal.Vector2d;
        abstract length(): number;
        abstract get(arg0: Internal.ByteBuffer_): Internal.ByteBuffer;
        abstract sub(arg0: number, arg1: number, arg2: Internal.Vector2d_): Internal.Vector2d;
        abstract div(arg0: Internal.Vector2fc_, arg1: Internal.Vector2d_): Internal.Vector2d;
        abstract minComponent(): number;
        abstract get(arg0: number, arg1: Internal.Vector2i_): Internal.Vector2i;
        abstract maxComponent(): number;
        abstract mul(arg0: Internal.Matrix2dc_, arg1: Internal.Vector2d_): Internal.Vector2d;
        abstract normalize(arg0: number, arg1: Internal.Vector2d_): Internal.Vector2d;
        abstract negate(arg0: Internal.Vector2d_): Internal.Vector2d;
        abstract mulTranspose(arg0: Internal.Matrix2dc_, arg1: Internal.Vector2d_): Internal.Vector2d;
        abstract div(arg0: number, arg1: number, arg2: Internal.Vector2d_): Internal.Vector2d;
        abstract get(arg0: Internal.Vector2f_): Internal.Vector2f;
        abstract add(arg0: Internal.Vector2dc_, arg1: Internal.Vector2d_): Internal.Vector2d;
        abstract mulDirection(arg0: Internal.Matrix3x2dc_, arg1: Internal.Vector2d_): Internal.Vector2d;
        abstract get(arg0: number): number;
        abstract ceil(arg0: Internal.Vector2d_): Internal.Vector2d;
        abstract y(): number;
        abstract lengthSquared(): number;
        abstract fma(arg0: number, arg1: Internal.Vector2dc_, arg2: Internal.Vector2d_): Internal.Vector2d;
        abstract get(arg0: number, arg1: Internal.DoubleBuffer_): Internal.DoubleBuffer;
        abstract mul(arg0: number, arg1: number, arg2: Internal.Vector2d_): Internal.Vector2d;
        abstract distanceSquared(arg0: Internal.Vector2fc_): number;
        abstract distanceSquared(arg0: number, arg1: number): number;
        abstract distanceSquared(arg0: Internal.Vector2dc_): number;
        abstract normalize(arg0: Internal.Vector2d_): Internal.Vector2d;
        abstract mul(arg0: Internal.Vector2dc_, arg1: Internal.Vector2d_): Internal.Vector2d;
        abstract max(arg0: Internal.Vector2dc_, arg1: Internal.Vector2d_): Internal.Vector2d;
        abstract floor(arg0: Internal.Vector2d_): Internal.Vector2d;
        abstract sub(arg0: Internal.Vector2fc_, arg1: Internal.Vector2d_): Internal.Vector2d;
        abstract distance(arg0: number, arg1: number): number;
        abstract min(arg0: Internal.Vector2dc_, arg1: Internal.Vector2d_): Internal.Vector2d;
        abstract div(arg0: Internal.Vector2dc_, arg1: Internal.Vector2d_): Internal.Vector2d;
        abstract mulPosition(arg0: Internal.Matrix3x2dc_, arg1: Internal.Vector2d_): Internal.Vector2d;
        get finite(): boolean
    }
    type Vector2dc_ = Vector2dc;
    class EntityDimensions {
        constructor($$0: number, $$1: number, $$2: boolean)
        static fixed($$0: number, $$1: number): Internal.EntityDimensions;
        scale($$0: number): this;
        scale($$0: number, $$1: number): this;
        makeBoundingBox($$0: Vec3d_): Internal.AABB;
        static scalable($$0: number, $$1: number): Internal.EntityDimensions;
        makeBoundingBox($$0: number, $$1: number, $$2: number): Internal.AABB;
        readonly width: number;
        readonly height: number;
        readonly fixed: boolean;
    }
    type EntityDimensions_ = EntityDimensions;
    interface AccessorEmptyTextureStateShard {
        abstract hex$cutoutTexture(): Internal.Optional<ResourceLocation>;
        (): Internal.Optional_<ResourceLocation>;
    }
    type AccessorEmptyTextureStateShard_ = AccessorEmptyTextureStateShard;
    interface Dumpable {
        abstract dumpContents(arg0: ResourceLocation_, arg1: Internal.Path_): void;
        (arg0: ResourceLocation, arg1: Internal.Path): void;
    }
    type Dumpable_ = Dumpable;
    class EntityPositionSource implements Internal.PositionSource {
        constructor($$0: Internal.Entity_, $$1: number)
        getType(): Internal.PositionSourceType<any>;
        getPosition($$0: Internal.Level_): Internal.Optional<Vec3d>;
        get type(): Internal.PositionSourceType<any>
        static readonly CODEC: Internal.Codec<Internal.EntityPositionSource>;
    }
    type EntityPositionSource_ = EntityPositionSource;
    interface SlotAccess {
        forEquipmentSlot($$0: Internal.LivingEntity_, $$1: Internal.EquipmentSlot_): this;
        abstract set(arg0: Internal.ItemStack_): boolean;
        forContainer($$0: net.minecraft.world.Container_, $$1: number): this;
        abstract get(): Internal.ItemStack;
        forEquipmentSlot($$0: Internal.LivingEntity_, $$1: Internal.EquipmentSlot_, $$2: Internal.Predicate_<Internal.ItemStack>): this;
        forContainer($$0: net.minecraft.world.Container_, $$1: number, $$2: Internal.Predicate_<Internal.ItemStack>): this;
        readonly NULL: Internal.SlotAccess;
    }
    type SlotAccess_ = SlotAccess;
    class CreativeFluidTankMountedStorageType extends Internal.MountedFluidStorageType<Internal.CreativeFluidTankMountedStorage> {
        constructor()
        mount(level: Internal.Level_, state: Internal.BlockState_, pos: BlockPos_, be: Internal.BlockEntity_): Internal.CreativeFluidTankMountedStorage;
    }
    type CreativeFluidTankMountedStorageType_ = CreativeFluidTankMountedStorageType;
    class MonoBogeyBlock extends Internal.AbstractMonoBogeyBlock<Internal.MonoBogeyBlockEntity> {
        constructor(pProperties: Internal.BlockBehaviour$Properties_)
        newBlockEntity(p_153215_: BlockPos_, p_153216_: Internal.BlockState_): Internal.BlockEntity;
        canPlaceLiquid($$0: Internal.BlockGetter_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.Fluid_): boolean;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        static onRemove(blockState: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, newBlockState: Internal.BlockState_): void;
        updateWater(level: Internal.LevelAccessor_, state: Internal.BlockState_, pos: BlockPos_): void;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        pickupBlock($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_): Internal.ItemStack;
        onBlockEntityUse(world: Internal.BlockGetter_, pos: BlockPos_, action: Internal.Function_<Internal.MonoBogeyBlockEntity, Internal.InteractionResult>): Internal.InteractionResult;
        getPickupSound(): Internal.Optional<Internal.SoundEvent>;
        getBlockStates(): Internal.List<Internal.BlockState>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        getBlockEntityOptional(world: Internal.BlockGetter_, pos: BlockPos_): Internal.Optional<Internal.MonoBogeyBlockEntity>;
        fluidState(state: Internal.BlockState_): Internal.FluidState;
        setRequiresTool(v: boolean): void;
        static withWater(level: Internal.LevelAccessor_, placementState: Internal.BlockState_, pos: BlockPos_): Internal.BlockState;
        onSneakWrenched(state: Internal.BlockState_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        withWater(placementState: Internal.BlockState_, ctx: Internal.BlockPlaceContext_): Internal.BlockState;
        getMod(): string;
        getBlockEntityClass(): typeof Internal.MonoBogeyBlockEntity;
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        updateAfterWrenched(newState: Internal.BlockState_, context: Internal.UseOnContext_): Internal.BlockState;
        onWrenched(state: Internal.BlockState_, context: Internal.UseOnContext_): Internal.InteractionResult;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        static playRemoveSound(level: Internal.Level_, pos: BlockPos_): void;
        getBlockEntity(worldIn: Internal.BlockGetter_, pos: BlockPos_): Internal.MonoBogeyBlockEntity;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        placeLiquid($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.FluidState_): boolean;
        getListener<T extends Internal.BlockEntity>($$0: Internal.ServerLevel_, $$1: T): Internal.GameEventListener;
        arch$holder(): Internal.Holder<Internal.Block>;
        withBlockEntityDo(world: Internal.BlockGetter_, pos: BlockPos_, action: Internal.Consumer_<Internal.MonoBogeyBlockEntity>): void;
        emi(amount: number): Internal.EmiStack;
        getTicker<S extends Internal.BlockEntity>(p_153212_: Internal.Level_, p_153213_: Internal.BlockState_, p_153214_: Internal.BlockEntityType_<S>): Internal.BlockEntityTicker<S>;
        static playRotateSound(level: Internal.Level_, pos: BlockPos_): void;
        emi(): Internal.EmiStack;
        getBlockEntityType(): Internal.BlockEntityType<Internal.MonoBogeyBlockEntity>;
        get pickupSound(): Internal.Optional<Internal.SoundEvent>
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        get blockEntityClass(): typeof Internal.MonoBogeyBlockEntity
        set destroySpeed(v: number)
        get blockEntityType(): Internal.BlockEntityType<Internal.MonoBogeyBlockEntity>
    }
    type MonoBogeyBlock_ = MonoBogeyBlock;
    class LangEventJS extends Internal.EventJS {
        constructor(lang: string, map: Internal.Map_<Internal.LangEventJS$Key, string>)
        renameItem(item: Internal.ItemStack_, name: string): void;
        add(key: string, value: string): void;
        addAll(namespace: string, map: Internal.Map_<string, string>): void;
        add(namespace: string, key: string, value: string): void;
        renameEntity(id: ResourceLocation_, name: string): void;
        renameBiome(id: ResourceLocation_, name: string): void;
        addAll(map: Internal.Map_<string, string>): void;
        renameBlock(block: Internal.Block_, name: string): void;
        readonly map: Internal.Map<Internal.LangEventJS$Key, string>;
        static readonly PATTERN: Internal.Pattern;
        readonly lang: string;
    }
    type LangEventJS_ = LangEventJS;
    class ToolboxInventory extends io.github.fabricators_of_create.porting_lib.transfer.item.ItemStackHandler implements Internal.AccessorToolboxInventory {
        constructor(be: Internal.ToolboxBlockEntity_)
        supportsInsertion(): boolean;
        getFilters(): Internal.List<any>;
        distributeToCompartment(stack: Internal.ItemStack_, compartment: number, ctx: Internal.TransactionContext_): Internal.ItemStack;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        isItemValid(slot: number, resource: Internal.ItemVariant_): boolean;
        static asClass<T>(): Internal.Storage<T>;
        static cleanItemNBT(stack: Internal.ItemStack_): Internal.ItemStack;
        takeFromCompartment(amount: number, compartment: number, ctx: Internal.TransactionContext_): Internal.ItemStack;
        supportsExtraction(): boolean;
        static canItemsShareCompartment(stack1: Internal.ItemStack_, stack2: Internal.ItemStack_): boolean;
        extractSlot(slot: number, resource: Internal.ItemVariant_, maxAmount: number, transaction: Internal.TransactionContext_): number;
        insertSlot(slot: number, resource: Internal.ItemVariant_, maxAmount: number, transaction: Internal.TransactionContext_): number;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        simulateInsert(resource: Internal.ItemVariant_, maxAmount: number, transaction: Internal.TransactionContext_): number;
        forEach(arg0: Internal.Consumer_<Internal.StorageView<T>>): void;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        simulateExtract(resource: Internal.ItemVariant_, maxAmount: number, transaction: Internal.TransactionContext_): number;
        serializeNBT(): Internal.Tag;
        getVersion(): number;
        spliterator(): Internal.Spliterator<Internal.StorageView<T>>;
        settle(compartment: number): void;
        iterator(): Internal.Iterator<Internal.StorageView<Internal.ItemVariant>>;
        inLimitedMode(action: Internal.Consumer_<Internal.ToolboxInventory>): void;
        get filters(): Internal.List<any>
        get version(): number
        set tle(compartment: number)
        static readonly STACKS_PER_COMPARTMENT: 4;
        static readonly CODEC: Internal.Codec<Internal.ToolboxInventory>;
    }
    type ToolboxInventory_ = ToolboxInventory;
    class WallSignBlockBOP extends Internal.WallSignBlock {
        constructor(properties: Internal.BlockBehaviour$Properties_, type: Internal.WoodType_)
        canPlaceLiquid($$0: Internal.BlockGetter_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.Fluid_): boolean;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        pickupBlock($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_): Internal.ItemStack;
        getPickupSound(): Internal.Optional<Internal.SoundEvent>;
        getBlockStates(): Internal.List<Internal.BlockState>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        setRequiresTool(v: boolean): void;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        placeLiquid($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.FluidState_): boolean;
        getListener<T extends Internal.BlockEntity>($$0: Internal.ServerLevel_, $$1: T): Internal.GameEventListener;
        arch$holder(): Internal.Holder<Internal.Block>;
        emi(amount: number): Internal.EmiStack;
        emi(): Internal.EmiStack;
        get pickupSound(): Internal.Optional<Internal.SoundEvent>
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        set destroySpeed(v: number)
    }
    type WallSignBlockBOP_ = WallSignBlockBOP;
    interface ISettingsCategory <T extends Internal.ISettingsCategory<any>> {
        abstract deleteSlotSettingsFrom(arg0: number): void;
        abstract isLargerThanNumberOfSlots(arg0: number): boolean;
        abstract reloadFrom(arg0: Internal.CompoundTag_): void;
        abstract overwriteWith(arg0: T): void;
        abstract copyTo(arg0: T, arg1: number, arg2: number): void;
    }
    type ISettingsCategory_<T extends Internal.ISettingsCategory<any>> = ISettingsCategory<T>;
    class AgriFertilizer {
        constructor(mods: Internal.List_<string>, variants: Internal.List_<Internal.AgriFertilizerVariant>, triggerMutation: boolean, triggerWeeds: boolean, potency: number, reduceGrowth: boolean, killPlant: boolean, neutralOn: Internal.List_<Internal.ExtraCodecs$TagOrElementLocation>, negativeOn: Internal.List_<Internal.ExtraCodecs$TagOrElementLocation>, particles: Internal.List_<Internal.AgriFertilizerParticle>)
        isNeutralOn(plantId: ResourceLocation_): boolean;
        canTriggerWeeds(): boolean;
        canKillPlant(): boolean;
        canFertilize(target: Internal.IAgriFertilizable_): boolean;
        canTriggerMutation(): boolean;
        getParticles(type: string): Internal.List<Internal.AgriFertilizerParticle>;
        isNegativeOn(plantId: ResourceLocation_): boolean;
        applyFertilizer(level: Internal.Level_, pos: BlockPos_, fertilizable: Internal.IAgriFertilizable_, stack: Internal.ItemStack_, random: Internal.RandomSource_, entity: Internal.LivingEntity_): Internal.InteractionResult;
        affects(plantId: ResourceLocation_): boolean;
        variants(): Internal.List<Internal.AgriFertilizerVariant>;
        canReduceGrowth(): boolean;
        static readonly CODEC: Internal.Codec<Internal.AgriFertilizer>;
    }
    type AgriFertilizer_ = AgriFertilizer | Special.Fertilizers;
    class DragonTakeoffPhase extends Internal.AbstractDragonPhaseInstance {
        constructor($$0: Internal.EnderDragon_)
        getPhase(): Internal.EnderDragonPhase<Internal.DragonTakeoffPhase>;
        get phase(): Internal.EnderDragonPhase<Internal.DragonTakeoffPhase>
    }
    type DragonTakeoffPhase_ = DragonTakeoffPhase;
    class ClientTelemetryManager implements Internal.AutoCloseable {
        constructor($$0: Internal.Minecraft_, $$1: Internal.UserApiService_, $$2: Internal.User_)
        getOutsideSessionSender(): Internal.TelemetryEventSender;
        createWorldSessionManager($$0: boolean, $$1: Duration_, $$2: string): Internal.WorldSessionTelemetryManager;
        close(): void;
        getLogDirectory(): Internal.Path;
        get outsideSessionSender(): Internal.TelemetryEventSender
        get logDirectory(): Internal.Path
    }
    type ClientTelemetryManager_ = ClientTelemetryManager;
    class CombatEntry extends Internal.Record {
        constructor($$0: DamageSource_, $$1: number, $$2: Internal.FallLocation_, $$3: number)
        fallLocation(): Internal.FallLocation;
        damage(): number;
        source(): DamageSource;
        fallDistance(): number;
    }
    type CombatEntry_ = CombatEntry;
    class MoltenNetheriteFluid extends Internal.MoltenMetalFluid {
        constructor(properties: Internal.ModFlowingFluid$Properties_, block: Internal.Supplier_<Internal.LiquidBlock>)
        arch$holder(): Internal.Holder<Internal.Fluid>;
        arch$registryName(): ResourceLocation;
    }
    type MoltenNetheriteFluid_ = MoltenNetheriteFluid;
    class MobEffectInstance$FactorData {
        constructor($$0: number, $$1: number, $$2: number, $$3: number, $$4: number, $$5: number, $$6: boolean)
        constructor($$0: number)
        tick($$0: Internal.MobEffectInstance_): void;
        getFactor($$0: Internal.LivingEntity_, $$1: number): number;
        static readonly CODEC: Internal.Codec<Internal.MobEffectInstance$FactorData>;
    }
    type MobEffectInstance$FactorData_ = MobEffectInstance$FactorData;
    abstract class ReiSequencedAssemblySubCategory {
        constructor(width: number)
        getWidth(): number;
        addFluidIngredients(recipe: Internal.SequencedRecipe_<any>, widgets: Internal.List_<any>, x: number, index: number, origin: me.shedaniel.math.Point_): number;
        addItemIngredients(recipe: Internal.SequencedRecipe_<any>, widgets: Internal.List_<any>, x: number, index: number, origin: me.shedaniel.math.Point_): number;
        abstract draw(arg0: Internal.SequencedRecipe_<any>, arg1: Internal.GuiGraphics_, arg2: number, arg3: number, arg4: number): void;
        get width(): number
    }
    type ReiSequencedAssemblySubCategory_ = ReiSequencedAssemblySubCategory;
    class GameEvent$Context extends Internal.Record {
        constructor($$0: Internal.Entity_, $$1: Internal.BlockState_)
        static of($$0: Internal.Entity_): Internal.GameEvent$Context;
        static of($$0: Internal.Entity_, $$1: Internal.BlockState_): Internal.GameEvent$Context;
        affectedState(): Internal.BlockState;
        sourceEntity(): Internal.Entity;
        static of($$0: Internal.BlockState_): Internal.GameEvent$Context;
    }
    type GameEvent$Context_ = GameEvent$Context;
    class ServerboundChatAckPacket extends Internal.Record implements Internal.Packet<Internal.ServerGamePacketListener> {
        constructor($$0: Internal.FriendlyByteBuf_)
        constructor($$0: number)
        handle(arg0: Internal.PacketListener_): void;
        write($$0: Internal.FriendlyByteBuf_): void;
        handle($$0: Internal.ServerGamePacketListener_): void;
        offset(): number;
        isSkippable(): boolean;
        get skippable(): boolean
    }
    type ServerboundChatAckPacket_ = ServerboundChatAckPacket;
    interface ArmedModel {
        abstract translateToHand(arg0: Internal.HumanoidArm_, arg1: Internal.PoseStack_): void;
        (arg0: Internal.HumanoidArm, arg1: Internal.PoseStack): void;
    }
    type ArmedModel_ = ArmedModel;
    interface Cloneable {
    }
    type Cloneable_ = Cloneable;
    class SpecialHandlerMask$Companion {
        constructor($constructor_marker: any_)
        getNAME(): ResourceLocation;
        get NAME(): ResourceLocation
    }
    type SpecialHandlerMask$Companion_ = SpecialHandlerMask$Companion;
    interface DoubleBlockCombiner$NeighborCombineResult <S> {
        abstract apply<T>(arg0: Internal.DoubleBlockCombiner$Combiner_<S, T>): T;
        (arg0: Internal.DoubleBlockCombiner$Combiner<S, T>): T;
    }
    type DoubleBlockCombiner$NeighborCombineResult_<S> = DoubleBlockCombiner$NeighborCombineResult<S>;
    class RepairKitItem extends Internal.MaterialItem implements Internal.IRepairKitItem {
        constructor(properties: Internal.Item$Properties_, tab: Internal.ResourceKey_<Internal.CreativeModeTab>)
        hasCustomEntity(stack: Internal.ItemStack_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        allowContinuingBlockBreaking(player: Internal.Player_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getRecipeRemainder(stack: Internal.ItemStack_): Internal.ItemStack;
        withMaterial(material: Internal.MaterialVariantId_): Internal.ItemStack;
        onArmorTick(stack: Internal.ItemStack_, level: Internal.Level_, player: Internal.Player_): void;
        setDigSpeed(speed: number): void;
        onItemUseFirst(stack: Internal.ItemStack_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        setAttackSpeed(attackSpeed: number): void;
        withMaterialForDisplay(materialId: Internal.MaterialVariantId_): Internal.ItemStack;
        arch$registryName(): ResourceLocation;
        setAttackDamage(attackDamage: number): void;
        getAttributeModifiers(stack: Internal.ItemStack_, slot: Internal.EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        static port_lib$getPlayerPOVHitResult(level: Internal.Level_, player: Internal.Player_, fluidMode: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        arch$holder(): Internal.Holder<Internal.Item>;
        getMod(): string;
        static getBaseAttackDamageUUID(): Internal.UUID;
        createEntity(level: Internal.Level_, location: Internal.Entity_, stack: Internal.ItemStack_): Internal.Entity;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        getCreativeTab(): string;
        setArmorToughness(armorToughness: number): void;
        onDroppedByPlayer(stack: Internal.ItemStack_, player: Internal.Player_): boolean;
        allowNbtUpdateAnimation(player: Internal.Player_, hand: Internal.InteractionHand_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getRepairAmount(): number;
        static withMaterial(stack: Internal.ItemStack_, material: Internal.MaterialVariantId_): Internal.ItemStack;
        static getMaterialFromStack(stack: Internal.ItemStack_): Internal.MaterialVariantId;
        getDefaultTooltipHideFlags(stack: Internal.ItemStack_): number;
        canUseMaterial(mat: Internal.IMaterial_): boolean;
        emi(amount: number): Internal.EmiStack;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        emi(): Internal.EmiStack;
        isSuitableFor(stack: Internal.ItemStack_, state: Internal.BlockState_): boolean;
        onLeftClickEntity(stack: Internal.ItemStack_, player: Internal.Player_, entity: Internal.Entity_): boolean;
        getDigSpeed(): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(itemstack: Internal.ItemStack_, pos: BlockPos_, player: Internal.Player_): boolean;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        set attackDamage(attackDamage: number)
        get mod(): string
        get baseAttackDamageUUID(): Internal.UUID
        set armorProtection(armorProtection: number)
        get creativeTab(): string
        set armorToughness(armorToughness: number)
        get repairAmount(): number
        get digSpeed(): number
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
    }
    type RepairKitItem_ = RepairKitItem;
    class ConfigGroup implements Internal.Comparable<Internal.ConfigGroup> {
        constructor(id: string, savedCallback: Internal.ConfigCallback_)
        constructor(id: string)
        getTooltip(): net.minecraft.network.chat.Component;
        addItemStack(id: string, value: Internal.ItemStack_, setter: Internal.Consumer_<Internal.ItemStack>, def: Internal.ItemStack_, singleItem: boolean, allowEmpty: boolean): Internal.ItemStackConfig;
        addInt(id: string, value: number, setter: Internal.Consumer_<number>, def: number, min: number, max: number): Internal.IntConfig;
        getParent(): this;
        addItemStack(id: string, value: Internal.ItemStack_, setter: Internal.Consumer_<Internal.ItemStack>, def: Internal.ItemStack_, fixedSize: number): Internal.ItemStackConfig;
        addTristate(id: string, value: Internal.Tristate_, setter: Internal.Consumer_<Internal.Tristate>, def: Internal.Tristate_): Internal.EnumConfig<Internal.Tristate>;
        addList<E, CV extends Internal.ConfigValue<E>>(id: string, c: Internal.List_<E>, type: CV, def: E): Internal.ListConfig<E, CV>;
        setNameKey(key: string): this;
        addEnum<E>(id: string, value: E, setter: Internal.Consumer_<E>, nameMap: Internal.NameMap_<E>, def: E): Internal.EnumConfig<E>;
        compareTo(arg0: any): number;
        addColor(id: string, value: Internal.Color4I_, setter: Internal.Consumer_<Internal.Color4I>, def: Internal.Color4I_): Internal.ColorConfig;
        addFluidStack(id: string, value: dev.architectury.fluid.FluidStack_, setter: Internal.Consumer_<dev.architectury.fluid.FluidStack>, def: dev.architectury.fluid.FluidStack_, allowEmpty: boolean): Internal.FluidConfig;
        getSubgroups(): Internal.Collection<Internal.ConfigGroup>;
        getPath(): string;
        addString(id: string, value: string, setter: Internal.Consumer_<string>, def: string, pattern: Internal.Pattern_): Internal.StringConfig;
        addString(id: string, value: string, setter: Internal.Consumer_<string>, def: string): Internal.StringConfig;
        addBool(id: string, value: boolean, setter: Internal.Consumer_<boolean>, def: boolean): Internal.BooleanConfig;
        getName(): net.minecraft.network.chat.Component;
        compareTo(o: Internal.ConfigGroup_): number;
        getOrCreateSubgroup(id: string): this;
        getId(): string;
        addFluidStack(id: string, value: dev.architectury.fluid.FluidStack_, setter: Internal.Consumer_<dev.architectury.fluid.FluidStack>, def: dev.architectury.fluid.FluidStack_, fixedSize: number): Internal.FluidConfig;
        addLong(id: string, value: number, setter: Internal.Consumer_<number>, def: number, min: number, max: number): Internal.LongConfig;
        addEnum<E>(id: string, value: E, setter: Internal.Consumer_<E>, nameMap: Internal.NameMap_<E>): Internal.EnumConfig<E>;
        add<T, CV extends Internal.ConfigValue<T>>(id: string, type: CV, value: T, setter: Internal.Consumer_<T>, defaultValue: T): CV;
        addDouble(id: string, value: number, setter: Internal.Consumer_<number>, def: number, min: number, max: number): Internal.DoubleConfig;
        addTristate(id: string, value: Internal.Tristate_, setter: Internal.Consumer_<Internal.Tristate>): Internal.EnumConfig<Internal.Tristate>;
        getNameKey(): string;
        addImage(id: string, value: ResourceLocation_, setter: Internal.Consumer_<ResourceLocation>, def: ResourceLocation_): Internal.ImageResourceConfig;
        addList<E, CV extends Internal.ConfigValue<E>>(id: string, value: Internal.List_<E>, type: CV, setter: Internal.Consumer_<Internal.List<E>>, def: E): Internal.ListConfig<E, CV>;
        save(accepted: boolean): void;
        getOrCreateSubgroup(id: string, displayOrder: number): this;
        getValues(): Internal.Collection<Internal.ConfigValue<any>>;
        get tooltip(): net.minecraft.network.chat.Component
        get parent(): Internal.ConfigGroup
        set nameKey(key: string)
        get subgroups(): Internal.Collection<Internal.ConfigGroup>
        get path(): string
        get name(): net.minecraft.network.chat.Component
        get id(): string
        get nameKey(): string
        get values(): Internal.Collection<Internal.ConfigValue<any>>
    }
    type ConfigGroup_ = ConfigGroup;
    interface IPeripheralTileDucky {
        abstract getPeripheral(arg0: Internal.Direction_): Internal.IPeripheral;
        (arg0: Internal.Direction): Internal.IPeripheral_;
    }
    type IPeripheralTileDucky_ = IPeripheralTileDucky;
    interface Vector2fc {
        abstract mul(arg0: Internal.Matrix2dc_, arg1: Internal.Vector2f_): Internal.Vector2f;
        abstract get(arg0: number, arg1: Internal.ByteBuffer_): Internal.ByteBuffer;
        abstract get(arg0: Internal.FloatBuffer_): Internal.FloatBuffer;
        abstract negate(arg0: Internal.Vector2f_): Internal.Vector2f;
        abstract isFinite(): boolean;
        abstract get(arg0: Internal.Vector2d_): Internal.Vector2d;
        abstract add(arg0: number, arg1: number, arg2: Internal.Vector2f_): Internal.Vector2f;
        abstract ceil(arg0: Internal.Vector2f_): Internal.Vector2f;
        abstract x(): number;
        abstract normalize(arg0: Internal.Vector2f_): Internal.Vector2f;
        abstract mul(arg0: number, arg1: number, arg2: Internal.Vector2f_): Internal.Vector2f;
        abstract floor(arg0: Internal.Vector2f_): Internal.Vector2f;
        abstract sub(arg0: Internal.Vector2fc_, arg1: Internal.Vector2f_): Internal.Vector2f;
        abstract lengthSquared(): number;
        abstract get(arg0: number, arg1: Internal.FloatBuffer_): Internal.FloatBuffer;
        abstract div(arg0: number, arg1: number, arg2: Internal.Vector2f_): Internal.Vector2f;
        abstract get(arg0: Internal.ByteBuffer_): Internal.ByteBuffer;
        abstract lerp(arg0: Internal.Vector2fc_, arg1: number, arg2: Internal.Vector2f_): Internal.Vector2f;
        abstract get(arg0: number): number;
        abstract fma(arg0: Internal.Vector2fc_, arg1: Internal.Vector2fc_, arg2: Internal.Vector2f_): Internal.Vector2f;
        abstract angle(arg0: Internal.Vector2fc_): number;
        abstract minComponent(): number;
        abstract normalize(arg0: number, arg1: Internal.Vector2f_): Internal.Vector2f;
        abstract get(arg0: number, arg1: Internal.Vector2i_): Internal.Vector2i;
        abstract maxComponent(): number;
        abstract mul(arg0: number, arg1: Internal.Vector2f_): Internal.Vector2f;
        abstract equals(arg0: number, arg1: number): boolean;
        abstract distance(arg0: Internal.Vector2fc_): number;
        abstract mulTranspose(arg0: Internal.Matrix2fc_, arg1: Internal.Vector2f_): Internal.Vector2f;
        abstract get(arg0: Internal.Vector2f_): Internal.Vector2f;
        abstract equals(arg0: Internal.Vector2fc_, arg1: number): boolean;
        abstract getToAddress(arg0: number): this;
        abstract mul(arg0: Internal.Matrix2fc_, arg1: Internal.Vector2f_): Internal.Vector2f;
        abstract mulDirection(arg0: Internal.Matrix3x2fc_, arg1: Internal.Vector2f_): Internal.Vector2f;
        abstract add(arg0: Internal.Vector2fc_, arg1: Internal.Vector2f_): Internal.Vector2f;
        abstract y(): number;
        abstract absolute(arg0: Internal.Vector2f_): Internal.Vector2f;
        abstract length(): number;
        abstract dot(arg0: Internal.Vector2fc_): number;
        abstract div(arg0: number, arg1: Internal.Vector2f_): Internal.Vector2f;
        abstract mul(arg0: Internal.Vector2fc_, arg1: Internal.Vector2f_): Internal.Vector2f;
        abstract distanceSquared(arg0: number, arg1: number): number;
        abstract fma(arg0: number, arg1: Internal.Vector2fc_, arg2: Internal.Vector2f_): Internal.Vector2f;
        abstract max(arg0: Internal.Vector2fc_, arg1: Internal.Vector2f_): Internal.Vector2f;
        abstract round(arg0: Internal.Vector2f_): Internal.Vector2f;
        abstract distanceSquared(arg0: Internal.Vector2fc_): number;
        abstract min(arg0: Internal.Vector2fc_, arg1: Internal.Vector2f_): Internal.Vector2f;
        abstract div(arg0: Internal.Vector2fc_, arg1: Internal.Vector2f_): Internal.Vector2f;
        abstract distance(arg0: number, arg1: number): number;
        abstract sub(arg0: number, arg1: number, arg2: Internal.Vector2f_): Internal.Vector2f;
        abstract mulPosition(arg0: Internal.Matrix3x2fc_, arg1: Internal.Vector2f_): Internal.Vector2f;
        get finite(): boolean
    }
    type Vector2fc_ = Vector2fc;
    class GearboxBlock extends Internal.RotatedPillarKineticBlock implements Internal.BlockPickInteractionAware, Internal.IBE<Internal.GearboxBlockEntity> {
        constructor(properties: Internal.BlockBehaviour$Properties_)
        newBlockEntity(p_153215_: BlockPos_, p_153216_: Internal.BlockState_): Internal.BlockEntity;
        getBlockEntityClass(): typeof Internal.GearboxBlockEntity;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        static onRemove(blockState: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, newBlockState: Internal.BlockState_): void;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        onBlockEntityUse(world: Internal.BlockGetter_, pos: BlockPos_, action: Internal.Function_<Internal.GearboxBlockEntity, Internal.InteractionResult>): Internal.InteractionResult;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        hideStressImpact(): boolean;
        getBlockStates(): Internal.List<Internal.BlockState>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        getBlockEntityType(): Internal.BlockEntityType<Internal.GearboxBlockEntity>;
        setRequiresTool(v: boolean): void;
        onSneakWrenched(state: Internal.BlockState_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getBlockEntity(worldIn: Internal.BlockGetter_, pos: BlockPos_): Internal.GearboxBlockEntity;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        updateAfterWrenched(newState: Internal.BlockState_, context: Internal.UseOnContext_): Internal.BlockState;
        onWrenched(state: Internal.BlockState_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getRotatedBlockState(originalState: Internal.BlockState_, targetedFace: Internal.Direction_): Internal.BlockState;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        getPickedStack(state: Internal.BlockState_, view: Internal.BlockGetter_, pos: BlockPos_, player: Internal.Player_, result: Internal.HitResult_): Internal.ItemStack;
        static playRemoveSound(level: Internal.Level_, pos: BlockPos_): void;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        getBlockEntityOptional(world: Internal.BlockGetter_, pos: BlockPos_): Internal.Optional<Internal.GearboxBlockEntity>;
        showCapacityWithAnnotation(): boolean;
        withBlockEntityDo(world: Internal.BlockGetter_, pos: BlockPos_, action: Internal.Consumer_<Internal.GearboxBlockEntity>): void;
        getListener<T extends Internal.BlockEntity>($$0: Internal.ServerLevel_, $$1: T): Internal.GameEventListener;
        arch$holder(): Internal.Holder<Internal.Block>;
        getMinimumRequiredSpeedLevel(): Internal.IRotate$SpeedLevel;
        emi(amount: number): Internal.EmiStack;
        getTicker<S extends Internal.BlockEntity>(p_153212_: Internal.Level_, p_153213_: Internal.BlockState_, p_153214_: Internal.BlockEntityType_<S>): Internal.BlockEntityTicker<S>;
        static playRotateSound(level: Internal.Level_, pos: BlockPos_): void;
        emi(): Internal.EmiStack;
        get blockEntityClass(): typeof Internal.GearboxBlockEntity
        get blockStates(): Internal.List<Internal.BlockState>
        get blockEntityType(): Internal.BlockEntityType<Internal.GearboxBlockEntity>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        set destroySpeed(v: number)
        get minimumRequiredSpeedLevel(): Internal.IRotate$SpeedLevel
    }
    type GearboxBlock_ = GearboxBlock;
    class TheEndGatewayBlockEntity extends Internal.TheEndPortalBlockEntity {
        constructor($$0: BlockPos_, $$1: Internal.BlockState_)
        syncComponent(key: Internal.ComponentKey_<any>): void;
        static teleportEntity($$0: Internal.Level_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.Entity_, $$4: Internal.TheEndGatewayBlockEntity_): void;
        getCooldownPercent($$0: number): number;
        modifyAttached<A>(type: Internal.AttachmentType_<A>, modifier: Internal.UnaryOperator_<A>): A;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>): A;
        static teleportTick($$0: Internal.Level_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.TheEndGatewayBlockEntity_): void;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_): void;
        getUpdatePacket(): Internal.Packet<any>;
        onLoad(): void;
        getAttachedOrSet<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        removeAttached<A>(type: Internal.AttachmentType_<A>): A;
        getComponent<C extends dev.onyxstudios.cca.api.v3.component.Component>(key: Internal.ComponentKey_<C>): C;
        invalidateCaps(): void;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_, predicate: Internal.PlayerSyncPredicate_): void;
        asComponentProvider(): Internal.ComponentProvider;
        isSpawning(): boolean;
        getUpdatePacket(): Internal.ClientboundBlockEntityDataPacket;
        getAttachedOrGet<A>(type: Internal.AttachmentType_<A>, defaultValue: Internal.Supplier_<A>): A;
        getSpawnPercent($$0: number): number;
        isCoolingDown(): boolean;
        static transfer(original: Internal.AttachmentTarget_, target: Internal.AttachmentTarget_, isDeath: boolean): void;
        static beamAnimationTick($$0: Internal.Level_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.TheEndGatewayBlockEntity_): void;
        getAttachedOrElse<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>, initializer: Internal.Supplier_<A>): A;
        etf$getETFRenderState(): Internal.ETFEntityRenderState;
        setExitPosition($$0: BlockPos_, $$1: boolean): void;
        static canEntityTeleport($$0: Internal.Entity_): boolean;
        getAttachedOrThrow<A>(type: Internal.AttachmentType_<A>): A;
        getParticleAmount(): number;
        get updatePacket(): Internal.Packet<any>
        get spawning(): boolean
        get updatePacket(): Internal.ClientboundBlockEntityDataPacket
        get coolingDown(): boolean
        get particleAmount(): number
    }
    type TheEndGatewayBlockEntity_ = TheEndGatewayBlockEntity;
    class BracketBlock extends Internal.WrenchableDirectionalBlock {
        constructor(properties: Internal.BlockBehaviour$Properties_)
        getSuitableBracket(blockState: Internal.BlockState_, direction: Internal.Direction_): Internal.Optional<Internal.BlockState>;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        getBlockStates(): Internal.List<Internal.BlockState>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        setRequiresTool(v: boolean): void;
        onSneakWrenched(state: Internal.BlockState_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        updateAfterWrenched(newState: Internal.BlockState_, context: Internal.UseOnContext_): Internal.BlockState;
        onWrenched(state: Internal.BlockState_, context: Internal.UseOnContext_): Internal.InteractionResult;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        static playRemoveSound(level: Internal.Level_, pos: BlockPos_): void;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        arch$holder(): Internal.Holder<Internal.Block>;
        emi(amount: number): Internal.EmiStack;
        static playRotateSound(level: Internal.Level_, pos: BlockPos_): void;
        emi(): Internal.EmiStack;
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        set destroySpeed(v: number)
        static readonly TYPE: Internal.EnumProperty<Internal.BracketBlock$BracketType>;
        static readonly AXIS_ALONG_FIRST_COORDINATE: Internal.BooleanProperty;
    }
    type BracketBlock_ = BracketBlock;
    class ItemMEPackingTape extends Internal.Item {
        constructor()
        hasCustomEntity(stack: Internal.ItemStack_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        allowContinuingBlockBreaking(player: Internal.Player_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getRecipeRemainder(stack: Internal.ItemStack_): Internal.ItemStack;
        onArmorTick(stack: Internal.ItemStack_, level: Internal.Level_, player: Internal.Player_): void;
        setDigSpeed(speed: number): void;
        onItemUseFirst(stack: Internal.ItemStack_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        setAttackSpeed(attackSpeed: number): void;
        arch$registryName(): ResourceLocation;
        setAttackDamage(attackDamage: number): void;
        getAttributeModifiers(stack: Internal.ItemStack_, slot: Internal.EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        static port_lib$getPlayerPOVHitResult(level: Internal.Level_, player: Internal.Player_, fluidMode: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        arch$holder(): Internal.Holder<Internal.Item>;
        getMod(): string;
        static getBaseAttackDamageUUID(): Internal.UUID;
        createEntity(level: Internal.Level_, location: Internal.Entity_, stack: Internal.ItemStack_): Internal.Entity;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        getCreativeTab(): string;
        setArmorToughness(armorToughness: number): void;
        onDroppedByPlayer(stack: Internal.ItemStack_, player: Internal.Player_): boolean;
        allowNbtUpdateAnimation(player: Internal.Player_, hand: Internal.InteractionHand_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getDefaultTooltipHideFlags(stack: Internal.ItemStack_): number;
        getCreatorModId(itemStack: Internal.ItemStack_): string;
        emi(amount: number): Internal.EmiStack;
        static registerPackableDevice(id: ResourceLocation_): void;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        emi(): Internal.EmiStack;
        isSuitableFor(stack: Internal.ItemStack_, state: Internal.BlockState_): boolean;
        onLeftClickEntity(stack: Internal.ItemStack_, player: Internal.Player_, entity: Internal.Entity_): boolean;
        getDigSpeed(): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(itemstack: Internal.ItemStack_, pos: BlockPos_, player: Internal.Player_): boolean;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        set attackDamage(attackDamage: number)
        get mod(): string
        get baseAttackDamageUUID(): Internal.UUID
        set armorProtection(armorProtection: number)
        get creativeTab(): string
        set armorToughness(armorToughness: number)
        get digSpeed(): number
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
    }
    type ItemMEPackingTape_ = ItemMEPackingTape;
    interface MultiBufferSource {
        immediateWithBuffers(layerBuffers: Internal.Map_<any, any>, fallbackBuffer: Internal.BufferBuilder_): Internal.MultiBufferSource$BufferSource;
        immediate($$0: Internal.BufferBuilder_): Internal.MultiBufferSource$BufferSource;
        abstract getBuffer(arg0: Internal.RenderType_): Internal.VertexConsumer;
        (arg0: Internal.RenderType): Internal.VertexConsumer_;
    }
    type MultiBufferSource_ = MultiBufferSource;
    interface ConfigWriter {
        write(config: dev.lambdaurora.lambdynlights.shadow.nightconfig.core.UnmodifiableConfig_, file: Internal.File_, writingMode: dev.lambdaurora.lambdynlights.shadow.nightconfig.core.io.WritingMode_, charset: Internal.Charset_): void;
        write(config: dev.lambdaurora.lambdynlights.shadow.nightconfig.core.UnmodifiableConfig_, file: Internal.Path_, writingMode: dev.lambdaurora.lambdynlights.shadow.nightconfig.core.io.WritingMode_, charset: Internal.Charset_): void;
        write(config: dev.lambdaurora.lambdynlights.shadow.nightconfig.core.UnmodifiableConfig_, output: Internal.OutputStream_): void;
        write(config: dev.lambdaurora.lambdynlights.shadow.nightconfig.core.UnmodifiableConfig_, file: Internal.Path_, writingMode: dev.lambdaurora.lambdynlights.shadow.nightconfig.core.io.WritingMode_): void;
        write(config: dev.lambdaurora.lambdynlights.shadow.nightconfig.core.UnmodifiableConfig_, url: Internal.URL_): void;
        abstract write(arg0: dev.lambdaurora.lambdynlights.shadow.nightconfig.core.UnmodifiableConfig_, arg1: Internal.Writer_): void;
        write(config: dev.lambdaurora.lambdynlights.shadow.nightconfig.core.UnmodifiableConfig_, file: Internal.File_, writingMode: dev.lambdaurora.lambdynlights.shadow.nightconfig.core.io.WritingMode_): void;
        write(config: dev.lambdaurora.lambdynlights.shadow.nightconfig.core.UnmodifiableConfig_, output: Internal.OutputStream_, charset: Internal.Charset_): void;
        writeToString(config: dev.lambdaurora.lambdynlights.shadow.nightconfig.core.UnmodifiableConfig_): string;
        (arg0: dev.lambdaurora.lambdynlights.shadow.nightconfig.core.UnmodifiableConfig, arg1: Internal.Writer): void;
    }
    type ConfigWriter_ = ConfigWriter;
    interface SpawnGroupData {
    }
    type SpawnGroupData_ = SpawnGroupData;
    class ChronoField extends Internal.Enum<Internal.ChronoField> implements Internal.TemporalField {
        static valueOf(arg0: string): Internal.ChronoField;
        range(): Internal.ValueRange;
        checkValidIntValue(arg0: number): number;
        rangeRefinedBy(arg0: Internal.TemporalAccessor_): Internal.ValueRange;
        isSupportedBy(arg0: Internal.TemporalAccessor_): boolean;
        getDisplayName(arg0: Internal.Locale_): string;
        getBaseUnit(): Internal.TemporalUnit;
        resolve(arg0: Internal.Map_<Internal.TemporalField, number>, arg1: Internal.TemporalAccessor_, arg2: Internal.ResolverStyle_): Internal.TemporalAccessor;
        static values(): Internal.ChronoField[];
        isTimeBased(): boolean;
        isDateBased(): boolean;
        adjustInto<R extends Internal.Temporal>(arg0: R, arg1: number): R;
        checkValidValue(arg0: number): number;
        getRangeUnit(): Internal.TemporalUnit;
        getFrom(arg0: Internal.TemporalAccessor_): number;
        get baseUnit(): Internal.TemporalUnit
        get timeBased(): boolean
        get dateBased(): boolean
        get rangeUnit(): Internal.TemporalUnit
        static readonly ALIGNED_DAY_OF_WEEK_IN_YEAR: Internal.ChronoField;
        static readonly OFFSET_SECONDS: Internal.ChronoField;
        static readonly SECOND_OF_DAY: Internal.ChronoField;
        static readonly MILLI_OF_DAY: Internal.ChronoField;
        static readonly CLOCK_HOUR_OF_DAY: Internal.ChronoField;
        static readonly YEAR: Internal.ChronoField;
        static readonly MICRO_OF_DAY: Internal.ChronoField;
        static readonly ERA: Internal.ChronoField;
        static readonly DAY_OF_WEEK: Internal.ChronoField;
        static readonly MINUTE_OF_HOUR: Internal.ChronoField;
        static readonly DAY_OF_MONTH: Internal.ChronoField;
        static readonly PROLEPTIC_MONTH: Internal.ChronoField;
        static readonly INSTANT_SECONDS: Internal.ChronoField;
        static readonly EPOCH_DAY: Internal.ChronoField;
        static readonly NANO_OF_DAY: Internal.ChronoField;
        static readonly NANO_OF_SECOND: Internal.ChronoField;
        static readonly HOUR_OF_AMPM: Internal.ChronoField;
        static readonly MONTH_OF_YEAR: Internal.ChronoField;
        static readonly ALIGNED_WEEK_OF_YEAR: Internal.ChronoField;
        static readonly MICRO_OF_SECOND: Internal.ChronoField;
        static readonly AMPM_OF_DAY: Internal.ChronoField;
        static readonly HOUR_OF_DAY: Internal.ChronoField;
        static readonly MILLI_OF_SECOND: Internal.ChronoField;
        static readonly YEAR_OF_ERA: Internal.ChronoField;
        static readonly MINUTE_OF_DAY: Internal.ChronoField;
        static readonly CLOCK_HOUR_OF_AMPM: Internal.ChronoField;
        static readonly DAY_OF_YEAR: Internal.ChronoField;
        static readonly ALIGNED_WEEK_OF_MONTH: Internal.ChronoField;
        static readonly SECOND_OF_MINUTE: Internal.ChronoField;
        static readonly ALIGNED_DAY_OF_WEEK_IN_MONTH: Internal.ChronoField;
    }
    type ChronoField_ = "micro_of_second" | "proleptic_month" | "epoch_day" | "offset_seconds" | "aligned_week_of_year" | "ampm_of_day" | "milli_of_second" | "hour_of_ampm" | "aligned_day_of_week_in_year" | "hour_of_day" | "aligned_day_of_week_in_month" | "year_of_era" | "minute_of_hour" | ChronoField | "micro_of_day" | "second_of_minute" | "clock_hour_of_day" | "day_of_year" | "milli_of_day" | "minute_of_day" | "instant_seconds" | "day_of_week" | "aligned_week_of_month" | "nano_of_second" | "day_of_month" | "month_of_year" | "nano_of_day" | "second_of_day" | "year" | "era" | "clock_hour_of_ampm";
    interface FluidLike extends Internal.ReplacementMatch {
        of(o: any): Internal.ReplacementMatch;
        abstract getAmount(): number;
        matches(other: Internal.FluidLike_): boolean;
        copy(amount: number): this;
        isEmpty(): boolean;
        get amount(): number
        get empty(): boolean
        (): number;
    }
    type FluidLike_ = FluidLike;
    class PrimitiveDescJS extends Internal.Record implements Internal.TypeDescJS {
        constructor(type: string)
        static fixedArray(...types: Internal.TypeDescJS_[]): Internal.TypeDescJS;
        type(): string;
        build(): string;
        build(builder: Internal.StringBuilder_): void;
        or(type: Internal.TypeDescJS_): Internal.TypeDescJS;
        static object(): Internal.ObjectDescJS;
        asMap(): Internal.TypeDescJS;
        asArray(): Internal.TypeDescJS;
        static any(...types: Internal.TypeDescJS_[]): Internal.TypeDescJS;
        asMap(key: Internal.TypeDescJS_): Internal.TypeDescJS;
        withGenerics(...types: Internal.TypeDescJS_[]): Internal.TypeDescJS;
        static object(init: number): Internal.ObjectDescJS;
    }
    type PrimitiveDescJS_ = PrimitiveDescJS;
    class SoundEngine implements Internal.SoundEngineAccessor {
        constructor($$0: Internal.SoundManager_, $$1: Internal.Options_, $$2: Internal.ResourceProvider_)
        updateSource($$0: Internal.Camera_): void;
        play($$0: Internal.SoundInstance_): void;
        queueTickingSound($$0: Internal.TickableSoundInstance_): void;
        reload(): void;
        removeEventListener($$0: Internal.SoundEventListener_): void;
        stopAll(): void;
        destroy(): void;
        addEventListener($$0: Internal.SoundEventListener_): void;
        getSoundChannels(): Internal.Map<any, any>;
        resume(): void;
        updateCategoryVolume($$0: Internal.SoundSource_, $$1: number): void;
        stop($$0: Internal.SoundInstance_): void;
        getAvailableSoundDevices(): Internal.List<string>;
        getDebugString(): string;
        requestPreload($$0: Internal.Sound_): void;
        playDelayed($$0: Internal.SoundInstance_, $$1: number): void;
        tick($$0: boolean): void;
        isActive($$0: Internal.SoundInstance_): boolean;
        pause(): void;
        stop($$0: ResourceLocation_, $$1: Internal.SoundSource_): void;
        get soundChannels(): Internal.Map<any, any>
        get availableSoundDevices(): Internal.List<string>
        get debugString(): string
        readonly executor: Internal.SoundEngineExecutor;
        static readonly MISSING_SOUND: "FOR THE DEBUG!";
        static readonly OPEN_AL_SOFT_PREFIX: "OpenAL Soft on ";
        static readonly OPEN_AL_SOFT_PREFIX_LENGTH: 15;
    }
    type SoundEngine_ = SoundEngine;
    class WeatheringCopper$WeatherState extends Internal.Enum<Internal.WeatheringCopper$WeatherState> {
        static valueOf($$0: string): Internal.WeatheringCopper$WeatherState;
        static values(): Internal.WeatheringCopper$WeatherState[];
        static readonly WEATHERED: Internal.WeatheringCopper$WeatherState;
        static readonly EXPOSED: Internal.WeatheringCopper$WeatherState;
        static readonly UNAFFECTED: Internal.WeatheringCopper$WeatherState;
        static readonly OXIDIZED: Internal.WeatheringCopper$WeatherState;
    }
    type WeatheringCopper$WeatherState_ = "oxidized" | "unaffected" | WeatheringCopper$WeatherState | "weathered" | "exposed";
    class PiglinWallHeadBlock extends Internal.WallSkullBlock {
        constructor(type: Internal.SkullBlock$Type_, properties: Internal.BlockBehaviour$Properties_)
        static get($$0: Internal.ItemStack_): Internal.Equipable;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        getBlockStates(): Internal.List<Internal.BlockState>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        setRequiresTool(v: boolean): void;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getEquipSound(): Internal.SoundEvent;
        getMod(): string;
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        getListener<T extends Internal.BlockEntity>($$0: Internal.ServerLevel_, $$1: T): Internal.GameEventListener;
        arch$holder(): Internal.Holder<Internal.Block>;
        emi(amount: number): Internal.EmiStack;
        swapWithEquipmentSlot($$0: Internal.Item_, $$1: Internal.Level_, $$2: Internal.Player_, $$3: Internal.InteractionHand_): Internal.InteractionResultHolder<Internal.ItemStack>;
        emi(): Internal.EmiStack;
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get equipSound(): Internal.SoundEvent
        get mod(): string
        set destroySpeed(v: number)
    }
    type PiglinWallHeadBlock_ = PiglinWallHeadBlock;
    interface AccessorAbstractContraptionEntity {
        abstract railways$setSkipActorStop(arg0: boolean): void;
        abstract railways$moveCollidedEntitiesOnDisassembly(arg0: Internal.StructureTransform_): void;
    }
    type AccessorAbstractContraptionEntity_ = AccessorAbstractContraptionEntity;
    abstract class MishapEnvironment {
        abstract yeetHeldItemsTowards(arg0: Vec3d_): void;
        abstract removeXp(arg0: number): void;
        abstract dropHeldItems(): void;
        abstract blind(arg0: number): void;
        abstract drown(): void;
        abstract damage(arg0: number): void;
    }
    type MishapEnvironment_ = MishapEnvironment;
    class BlockMediafiedStorage extends Internal.Block implements Internal.IForgeLikeBlock, Internal.EntityBlock {
        constructor(properties: Internal.BlockBehaviour$Properties_)
        newBlockEntity(blockPos: BlockPos_, blockState: Internal.BlockState_): Internal.BlockEntity;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        newBlockEntity(pos: BlockPos_, state: Internal.BlockState_): Internal.BlockEntityMediafiedStorage;
        getBlockStates(): Internal.List<Internal.BlockState>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        static access$getCLOSED_SHAPE$cp(): Internal.VoxelShape;
        setRequiresTool(v: boolean): void;
        getTicker<T extends Internal.BlockEntity>(level: Internal.Level_, state: Internal.BlockState_, type: Internal.BlockEntityType_<T>): Internal.BlockEntityTicker<T>;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        hasEnchantPowerBonus(state: Internal.BlockState_, level: Internal.LevelReader_, pos: BlockPos_): boolean;
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        addLandingEffects(state: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        getListener<T extends Internal.BlockEntity>($$0: Internal.ServerLevel_, $$1: T): Internal.GameEventListener;
        arch$holder(): Internal.Holder<Internal.Block>;
        static access$getOPEN_SHAPE$cp(): Internal.VoxelShape;
        emi(amount: number): Internal.EmiStack;
        emi(): Internal.EmiStack;
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        set destroySpeed(v: number)
        static readonly Companion: Internal.BlockMediafiedStorage$Companion;
    }
    type BlockMediafiedStorage_ = BlockMediafiedStorage;
    class TagDependentIngredientItem extends Internal.Item {
        constructor(properties: Internal.Item$Properties_, tag: Internal.TagKey_<Internal.Item>)
        hasCustomEntity(stack: Internal.ItemStack_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        allowContinuingBlockBreaking(player: Internal.Player_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getRecipeRemainder(stack: Internal.ItemStack_): Internal.ItemStack;
        onArmorTick(stack: Internal.ItemStack_, level: Internal.Level_, player: Internal.Player_): void;
        setDigSpeed(speed: number): void;
        onItemUseFirst(stack: Internal.ItemStack_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        setAttackSpeed(attackSpeed: number): void;
        arch$registryName(): ResourceLocation;
        setAttackDamage(attackDamage: number): void;
        getAttributeModifiers(stack: Internal.ItemStack_, slot: Internal.EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        static port_lib$getPlayerPOVHitResult(level: Internal.Level_, player: Internal.Player_, fluidMode: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        arch$holder(): Internal.Holder<Internal.Item>;
        getMod(): string;
        static getBaseAttackDamageUUID(): Internal.UUID;
        createEntity(level: Internal.Level_, location: Internal.Entity_, stack: Internal.ItemStack_): Internal.Entity;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        getCreativeTab(): string;
        setArmorToughness(armorToughness: number): void;
        shouldHide(): boolean;
        onDroppedByPlayer(stack: Internal.ItemStack_, player: Internal.Player_): boolean;
        allowNbtUpdateAnimation(player: Internal.Player_, hand: Internal.InteractionHand_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getDefaultTooltipHideFlags(stack: Internal.ItemStack_): number;
        getCreatorModId(itemStack: Internal.ItemStack_): string;
        emi(amount: number): Internal.EmiStack;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        emi(): Internal.EmiStack;
        isSuitableFor(stack: Internal.ItemStack_, state: Internal.BlockState_): boolean;
        onLeftClickEntity(stack: Internal.ItemStack_, player: Internal.Player_, entity: Internal.Entity_): boolean;
        getDigSpeed(): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(itemstack: Internal.ItemStack_, pos: BlockPos_, player: Internal.Player_): boolean;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        set attackDamage(attackDamage: number)
        get mod(): string
        get baseAttackDamageUUID(): Internal.UUID
        set armorProtection(armorProtection: number)
        get creativeTab(): string
        set armorToughness(armorToughness: number)
        get digSpeed(): number
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
    }
    type TagDependentIngredientItem_ = TagDependentIngredientItem;
    class GoalSelectorDebugRenderer implements Internal.DebugRenderer$SimpleDebugRenderer {
        constructor($$0: Internal.Minecraft_)
        removeGoalSelector($$0: number): void;
        render($$0: Internal.PoseStack_, $$1: Internal.MultiBufferSource_, $$2: number, $$3: number, $$4: number): void;
        clear(): void;
        addGoalSelector($$0: number, $$1: Internal.List_<Internal.GoalSelectorDebugRenderer$DebugGoal>): void;
    }
    type GoalSelectorDebugRenderer_ = GoalSelectorDebugRenderer;
    abstract class AbstractObject2FloatMap <K> extends Internal.AbstractObject2FloatFunction<K> implements Internal.Serializable, Internal.Object2FloatMap<K> {
        andThenObject<T>(arg0: Internal.Float2ObjectFunction_<T>): Internal.Object2ObjectFunction<K, T>;
        andThenChar(arg0: Internal.Float2CharFunction_): Internal.Object2CharFunction<K>;
        /**
         * @deprecated
        */
        containsValue(arg0: any): boolean;
        values(): Internal.FloatCollection;
        composeFloat(arg0: Internal.Float2ObjectFunction_<K>): Internal.Float2FloatFunction;
        mergeFloat(arg0: K, arg1: number, arg2: Internal.FloatBinaryOperator_): number;
        removeFloat(arg0: any): number;
        andThenReference<T>(arg0: Internal.Float2ReferenceFunction_<T>): Internal.Object2ReferenceFunction<K, T>;
        getOrDefault(arg0: any, arg1: number): number;
        apply(arg0: K): number;
        compose<V>(arg0: Internal.Function_<V, K>): Internal.Function<V, number>;
        mergeFloat(arg0: K, arg1: number, arg2: Internal.DoubleBinaryOperator_): number;
        keySet(): Internal.Set<any>;
        static of<K, V>(arg0: K, arg1: V, arg2: K, arg3: V, arg4: K, arg5: V): Internal.Map<K, V>;
        computeIfPresent(arg0: K, arg1: Internal.BiFunction_<K, number, number>): number;
        /**
         * @deprecated
        */
        replace(arg0: any, arg1: any, arg2: any): boolean;
        computeIfAbsent(arg0: K, arg1: Internal.ToDoubleFunction_<K>): number;
        /**
         * @deprecated
        */
        put(arg0: any, arg1: any): any;
        static copyOf<K, V>(arg0: Internal.Map_<K, V>): Internal.Map<K, V>;
        /**
         * @deprecated
        */
        putIfAbsent(arg0: K, arg1: number): number;
        put(arg0: K, arg1: number): number;
        composeDouble(arg0: Internal.Double2ObjectFunction_<K>): Internal.Double2FloatFunction;
        containsValue(arg0: number): boolean;
        /**
         * @deprecated
        */
        andThen<T>(arg0: Internal.Function_<number, T>): Internal.Function<K, T>;
        static of<K, V>(arg0: K, arg1: V, arg2: K, arg3: V, arg4: K, arg5: V, arg6: K, arg7: V, arg8: K, arg9: V, arg10: K, arg11: V): Internal.Map<K, V>;
        computeIfAbsent(arg0: K, arg1: Internal.Object2FloatFunction_<K>): number;
        composeObject<T>(arg0: Internal.Object2ObjectFunction_<T, K>): Internal.Object2FloatFunction<T>;
        /**
         * @deprecated
        */
        getOrDefault(arg0: any, arg1: number): number;
        composeLong(arg0: Internal.Long2ObjectFunction_<K>): Internal.Long2FloatFunction;
        remove(arg0: any, arg1: number): boolean;
        composeInt(arg0: Internal.Int2ObjectFunction_<K>): Internal.Int2FloatFunction;
        abstract object2FloatEntrySet(): Internal.ObjectSet<Internal.Object2FloatMap$Entry<K>>;
        static of<K, V>(arg0: K, arg1: V, arg2: K, arg3: V, arg4: K, arg5: V, arg6: K, arg7: V): Internal.Map<K, V>;
        static ofEntries<K, V>(...arg0: Internal.Map$Entry_<K, V>[]): Internal.Map<K, V>;
        putAll(arg0: Internal.Map_<K, number>): void;
        computeFloat(arg0: K, arg1: Internal.BiFunction_<K, number, number>): number;
        /**
         * @deprecated
        */
        remove(arg0: any): any;
        static identity<T>(): Internal.Function<T, T>;
        replace(arg0: K, arg1: number): number;
        /**
         * @deprecated
        */
        merge(arg0: K, arg1: number, arg2: Internal.BiFunction_<number, number, number>): number;
        /**
         * @deprecated
        */
        putIfAbsent(arg0: any, arg1: any): any;
        forEach(arg0: Internal.BiConsumer_<K, number>): void;
        static of<K, V>(arg0: K, arg1: V): Internal.Map<K, V>;
        /**
         * @deprecated
        */
        get(arg0: any): number;
        /**
         * @deprecated
        */
        getOrDefault(arg0: any, arg1: any): any;
        static of<K, V>(): Internal.Map<K, V>;
        /**
         * @deprecated
        */
        computeFloatIfAbsent(arg0: K, arg1: Internal.ToDoubleFunction_<K>): number;
        isEmpty(): boolean;
        andThenShort(arg0: Internal.Float2ShortFunction_): Internal.Object2ShortFunction<K>;
        static entry<K, V>(arg0: K, arg1: V): Internal.Map$Entry<K, V>;
        andThenByte(arg0: Internal.Float2ByteFunction_): Internal.Object2ByteFunction<K>;
        composeReference<T>(arg0: Internal.Reference2ObjectFunction_<T, K>): Internal.Reference2FloatFunction<T>;
        computeFloatIfPresent(arg0: K, arg1: Internal.BiFunction_<K, number, number>): number;
        /**
         * @deprecated
        */
        entrySet(): Internal.ObjectSet<Internal.Map$Entry<K, number>>;
        /**
         * @deprecated
        */
        replace(arg0: K, arg1: number, arg2: number): boolean;
        composeByte(arg0: Internal.Byte2ObjectFunction_<K>): Internal.Byte2FloatFunction;
        compute(arg0: K, arg1: Internal.BiFunction_<K, number, number>): number;
        /**
         * @deprecated
        */
        computeFloatIfAbsentPartial(arg0: K, arg1: Internal.Object2FloatFunction_<K>): number;
        applyAsDouble(arg0: K): number;
        /**
         * @deprecated
        */
        replace(arg0: K, arg1: number): number;
        composeChar(arg0: Internal.Char2ObjectFunction_<K>): Internal.Char2FloatFunction;
        static of<K, V>(arg0: K, arg1: V, arg2: K, arg3: V, arg4: K, arg5: V, arg6: K, arg7: V, arg8: K, arg9: V): Internal.Map<K, V>;
        andThenDouble(arg0: Internal.Float2DoubleFunction_): Internal.Object2DoubleFunction<K>;
        static of<K, V>(arg0: K, arg1: V, arg2: K, arg3: V): Internal.Map<K, V>;
        /**
         * @deprecated
        */
        remove(arg0: any, arg1: any): boolean;
        /**
         * @deprecated
        */
        mergeFloat(arg0: K, arg1: number, arg2: Internal.BiFunction_<number, number, number>): number;
        static of<K, V>(arg0: K, arg1: V, arg2: K, arg3: V, arg4: K, arg5: V, arg6: K, arg7: V, arg8: K, arg9: V, arg10: K, arg11: V, arg12: K, arg13: V, arg14: K, arg15: V): Internal.Map<K, V>;
        replaceAll(arg0: Internal.BiFunction_<K, number, number>): void;
        merge(arg0: K, arg1: number, arg2: Internal.BiFunction_<number, number, number>): number;
        static of<K, V>(arg0: K, arg1: V, arg2: K, arg3: V, arg4: K, arg5: V, arg6: K, arg7: V, arg8: K, arg9: V, arg10: K, arg11: V, arg12: K, arg13: V, arg14: K, arg15: V, arg16: K, arg17: V, arg18: K, arg19: V): Internal.Map<K, V>;
        composeShort(arg0: Internal.Short2ObjectFunction_<K>): Internal.Short2FloatFunction;
        andThenLong(arg0: Internal.Float2LongFunction_): Internal.Object2LongFunction<K>;
        static of<K, V>(arg0: K, arg1: V, arg2: K, arg3: V, arg4: K, arg5: V, arg6: K, arg7: V, arg8: K, arg9: V, arg10: K, arg11: V, arg12: K, arg13: V, arg14: K, arg15: V, arg16: K, arg17: V): Internal.Map<K, V>;
        clear(): void;
        /**
         * @deprecated
        */
        replace(arg0: any, arg1: any): any;
        /**
         * @deprecated
        */
        merge(arg0: any, arg1: any, arg2: Internal.BiFunction_<any, any, any>): any;
        replace(arg0: K, arg1: number, arg2: number): boolean;
        static of<K, V>(arg0: K, arg1: V, arg2: K, arg3: V, arg4: K, arg5: V, arg6: K, arg7: V, arg8: K, arg9: V, arg10: K, arg11: V, arg12: K, arg13: V): Internal.Map<K, V>;
        /**
         * @deprecated
        */
        put(arg0: K, arg1: number): number;
        putIfAbsent(arg0: K, arg1: number): number;
        andThenInt(arg0: Internal.Float2IntFunction_): Internal.Object2IntFunction<K>;
        andThenFloat(arg0: Internal.Float2FloatFunction_): Internal.Object2FloatFunction<K>;
        computeIfAbsent(arg0: K, arg1: Internal.Function_<K, number>): number;
        get empty(): boolean
    }
    type AbstractObject2FloatMap_<K> = AbstractObject2FloatMap<K>;
    class AmethystBlock extends Internal.Block {
        constructor($$0: Internal.BlockBehaviour$Properties_)
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        getBlockStates(): Internal.List<Internal.BlockState>;
        arch$holder(): Internal.Holder<Internal.Block>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        emi(amount: number): Internal.EmiStack;
        setRequiresTool(v: boolean): void;
        emi(): Internal.EmiStack;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        set destroySpeed(v: number)
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
    }
    type AmethystBlock_ = AmethystBlock;
    class FieldInfo {
        constructor(fieldInfo: any_)
        isFinal(): boolean;
        getType(): Internal.ITypeInfo;
        getStaticValue(): any;
        getAnnotations(): Internal.List<Internal.Annotation>;
        isTransient(): boolean;
        getName(): string;
        shouldHide(): boolean;
        isStatic(): boolean;
        setTypeInfo(info: Internal.ITypeInfo_): void;
        get "final"(): boolean
        get type(): Internal.ITypeInfo
        get staticValue(): any
        get annotations(): Internal.List<Internal.Annotation>
        get "transient"(): boolean
        get name(): string
        get "static"(): boolean
        set typeInfo(info: Internal.ITypeInfo_)
    }
    type FieldInfo_ = FieldInfo;
    class TrinketEnums$DropRule extends Internal.Enum<Internal.TrinketEnums$DropRule> {
        static has(name: string): boolean;
        static values(): Internal.TrinketEnums$DropRule[];
        static valueOf(name: string): Internal.TrinketEnums$DropRule;
        static readonly DESTROY: Internal.TrinketEnums$DropRule;
        static readonly DROP: Internal.TrinketEnums$DropRule;
        static readonly KEEP: Internal.TrinketEnums$DropRule;
        static readonly DEFAULT: Internal.TrinketEnums$DropRule;
    }
    type TrinketEnums$DropRule_ = "keep" | "drop" | TrinketEnums$DropRule | "destroy" | "default";
    interface BaseBlockStateExtension {
        canEntityDestroy(level: Internal.BlockGetter_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        isSlimeBlock(): boolean;
        isStickyBlock(): boolean;
        getBeaconColorMultiplier(level: Internal.LevelReader_, pos: BlockPos_, beacon: BlockPos_): number[];
        onDestroyedByPlayer(level: Internal.Level_, pos: BlockPos_, player: Internal.Player_, willHarvest: boolean, fluid: Internal.FluidState_): boolean;
        canStickTo(other: Internal.BlockState_): boolean;
        get slimeBlock(): boolean
        get stickyBlock(): boolean
    }
    type BaseBlockStateExtension_ = BaseBlockStateExtension;
    interface BlockViewMixin extends Internal.FabricBlockView {
        hasBiomes(): boolean;
        getBlockEntityRenderData(pos: BlockPos_): any;
        getBiomeFabric(pos: BlockPos_): Internal.Holder<Internal.Biome>;
    }
    type BlockViewMixin_ = BlockViewMixin;
    class GlowingMossBlock extends Internal.MossBlock implements Internal.BonemealableBlock {
        constructor(p_153790_: Internal.BlockBehaviour$Properties_)
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        getBlockStates(): Internal.List<Internal.BlockState>;
        arch$holder(): Internal.Holder<Internal.Block>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        emi(amount: number): Internal.EmiStack;
        setRequiresTool(v: boolean): void;
        emi(): Internal.EmiStack;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        set destroySpeed(v: number)
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
    }
    type GlowingMossBlock_ = GlowingMossBlock;
    class OrientableBlock extends Internal.Block {
        constructor(properties: Internal.BlockBehaviour$Properties_)
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        getBlockStates(): Internal.List<Internal.BlockState>;
        arch$holder(): Internal.Holder<Internal.Block>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        emi(amount: number): Internal.EmiStack;
        setRequiresTool(v: boolean): void;
        emi(): Internal.EmiStack;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        set destroySpeed(v: number)
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        static readonly FACING: Internal.DirectionProperty;
    }
    type OrientableBlock_ = OrientableBlock;
    abstract class HeightProvider {
        constructor()
        abstract sample(arg0: Internal.RandomSource_, arg1: Internal.WorldGenerationContext_): number;
        abstract getType(): Internal.HeightProviderType<any>;
        get type(): Internal.HeightProviderType<any>
        static readonly CODEC: Internal.Codec<Internal.HeightProvider>;
    }
    type HeightProvider_ = HeightProvider;
    interface EntityEvents$EnteringSection {
        abstract onEntityEnterSection(arg0: Internal.Entity_, arg1: number, arg2: number): void;
        (arg0: Internal.Entity, arg1: number, arg2: number): void;
    }
    type EntityEvents$EnteringSection_ = EntityEvents$EnteringSection;
    class StonecutterUpgradeItem extends Internal.UpgradeItemBase<Internal.StonecutterUpgradeWrapper> {
        constructor(upgradeTypeLimitConfig: any_)
        hasCustomEntity(stack: Internal.ItemStack_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        allowContinuingBlockBreaking(player: Internal.Player_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getRecipeRemainder(stack: Internal.ItemStack_): Internal.ItemStack;
        onArmorTick(stack: Internal.ItemStack_, level: Internal.Level_, player: Internal.Player_): void;
        setDigSpeed(speed: number): void;
        onItemUseFirst(stack: Internal.ItemStack_, context: Internal.UseOnContext_): Internal.InteractionResult;
        checkThisForConflictsWithExistingUpgrades(upgradeStack: Internal.ItemStack_, storageWrapper: Internal.IStorageWrapper_, excludeUpgradeSlot: number): Internal.UpgradeSlotChangeResult;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        canRemoveUpgradeFrom(storageWrapper: Internal.IStorageWrapper_, isClientSide: boolean, player: Internal.Player_): Internal.UpgradeSlotChangeResult;
        setAttackSpeed(attackSpeed: number): void;
        getCleanedUpgradeStack(upgradeStack: Internal.ItemStack_): Internal.ItemStack;
        arch$registryName(): ResourceLocation;
        setAttackDamage(attackDamage: number): void;
        getAttributeModifiers(stack: Internal.ItemStack_, slot: Internal.EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        static port_lib$getPlayerPOVHitResult(level: Internal.Level_, player: Internal.Player_, fluidMode: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        arch$holder(): Internal.Holder<Internal.Item>;
        getMod(): string;
        static getBaseAttackDamageUUID(): Internal.UUID;
        createEntity(level: Internal.Level_, location: Internal.Entity_, stack: Internal.ItemStack_): Internal.Entity;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        getInventoryColumnsTaken(): number;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        getCreativeTab(): string;
        setArmorToughness(armorToughness: number): void;
        onDroppedByPlayer(stack: Internal.ItemStack_, player: Internal.Player_): boolean;
        canSwapUpgradeFor(upgradeStackToPut: Internal.ItemStack_, upgradeSlot: number, storageWrapper: Internal.IStorageWrapper_, isClientSide: boolean): Internal.UpgradeSlotChangeResult;
        allowNbtUpdateAnimation(player: Internal.Player_, hand: Internal.InteractionHand_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        checkExtraInsertConditions(upgradeStack: Internal.ItemStack_, storageWrapper: Internal.IStorageWrapper_, isClientSide: boolean, upgradeInSlot: Internal.IUpgradeItem_<any>): Internal.UpgradeSlotChangeResult;
        getDefaultTooltipHideFlags(stack: Internal.ItemStack_): number;
        getCreatorModId(itemStack: Internal.ItemStack_): string;
        canAddUpgradeTo(storageWrapper: Internal.IStorageWrapper_, upgradeStack: Internal.ItemStack_, firstLevelStorage: boolean, isClientSide: boolean): Internal.UpgradeSlotChangeResult;
        getType(): Internal.UpgradeType<Internal.StonecutterUpgradeWrapper>;
        emi(amount: number): Internal.EmiStack;
        getUpgradeGroup(): Internal.UpgradeGroup;
        canRemoveUpgradeFrom(storageWrapper: Internal.IStorageWrapper_, isClientSide: boolean): Internal.UpgradeSlotChangeResult;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        emi(): Internal.EmiStack;
        isSuitableFor(stack: Internal.ItemStack_, state: Internal.BlockState_): boolean;
        onLeftClickEntity(stack: Internal.ItemStack_, player: Internal.Player_, entity: Internal.Entity_): boolean;
        getDigSpeed(): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(itemstack: Internal.ItemStack_, pos: BlockPos_, player: Internal.Player_): boolean;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        set attackDamage(attackDamage: number)
        get mod(): string
        get baseAttackDamageUUID(): Internal.UUID
        get inventoryColumnsTaken(): number
        set armorProtection(armorProtection: number)
        get creativeTab(): string
        set armorToughness(armorToughness: number)
        get type(): Internal.UpgradeType<Internal.StonecutterUpgradeWrapper>
        get upgradeGroup(): Internal.UpgradeGroup
        get digSpeed(): number
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
    }
    type StonecutterUpgradeItem_ = StonecutterUpgradeItem;
    class MangrovePropaguleBlock extends Internal.SaplingBlock implements Internal.SimpleWaterloggedBlock {
        constructor($$0: Internal.BlockBehaviour$Properties_)
        static createNewHangingPropagule(): Internal.BlockState;
        getPlantType(world: Internal.BlockGetter_, pos: BlockPos_): Internal.PlantType;
        canPlaceLiquid($$0: Internal.BlockGetter_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.Fluid_): boolean;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        pickupBlock($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_): Internal.ItemStack;
        getPickupSound(): Internal.Optional<Internal.SoundEvent>;
        getBlockStates(): Internal.List<Internal.BlockState>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        setRequiresTool(v: boolean): void;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        static createNewHangingPropagule($$0: number): Internal.BlockState;
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        placeLiquid($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.FluidState_): boolean;
        arch$holder(): Internal.Holder<Internal.Block>;
        emi(amount: number): Internal.EmiStack;
        emi(): Internal.EmiStack;
        get pickupSound(): Internal.Optional<Internal.SoundEvent>
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        set destroySpeed(v: number)
        static readonly AGE: Internal.IntegerProperty;
        static readonly MAX_AGE: 4;
        static readonly HANGING: Internal.BooleanProperty;
    }
    type MangrovePropaguleBlock_ = MangrovePropaguleBlock;
    class TooltipList {
        constructor()
        getLines(): Internal.List<net.minecraft.network.chat.Component>;
        translate(key: string, ...objects: any[]): void;
        styledTranslate(key: string, style: Internal.Style_, ...objects: any[]): void;
        render(graphics: Internal.GuiGraphics_, mouseX: number, mouseY: number, screenWidth: number, screenHeight: number, font: net.minecraft.client.gui.Font_): void;
        styledString(text: string, color: Internal.ChatFormatting_): void;
        styledString(text: string, style: Internal.Style_): void;
        shouldRender(): boolean;
        reset(): void;
        add(component: net.minecraft.network.chat.Component_): void;
        blankLine(): void;
        string(text: string): void;
        get lines(): Internal.List<net.minecraft.network.chat.Component>
        backgroundColor: number;
        maxWidth: number;
        zOffsetItemTooltip: number;
        xOffset: number;
        zOffset: number;
        borderColorStart: number;
        borderColorEnd: number;
        yOffset: number;
    }
    type TooltipList_ = TooltipList;
    class BlockModificationEventJS extends Internal.EventJS {
        constructor()
        /**
         * Modifies blocks that match the given predicate.
         * 
         * **NOTE**: tag predicates are not supported at this time.
        */
        modify(predicate: BlockStatePredicate_, c: Internal.Consumer_<Internal.Block>): void;
    }
    type BlockModificationEventJS_ = BlockModificationEventJS;
    class DiskConfiguration extends Internal.Record implements Internal.FeatureConfiguration {
        constructor($$0: Internal.RuleBasedBlockStateProvider_, $$1: net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate_, $$2: Internal.IntProvider_, $$3: number)
        radius(): Internal.IntProvider;
        getFeatures(): Internal.Stream<Internal.ConfiguredFeature<any, any>>;
        target(): net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
        stateProvider(): Internal.RuleBasedBlockStateProvider;
        halfHeight(): number;
        get features(): Internal.Stream<Internal.ConfiguredFeature<any, any>>
        static readonly CODEC: Internal.Codec<Internal.DiskConfiguration>;
    }
    type DiskConfiguration_ = DiskConfiguration;
    class MatchingBlocksPredicate extends Internal.StateTestingPredicate {
        constructor($$0: Vec3i_, $$1: Internal.HolderSet_<Internal.Block>)
        static hasSturdyFace($$0: Internal.Direction_): net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
        static noFluid($$0: Vec3i_): net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
        and(arg0: Internal.BiPredicate_<Internal.WorldGenLevel, BlockPos>): Internal.BiPredicate<Internal.WorldGenLevel, BlockPos>;
        static matchesTag($$0: Vec3i_, $$1: Internal.TagKey_<Internal.Block>): net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
        static anyOf($$0: Internal.List_<net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate>): net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
        static noFluid(): net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
        static anyOf($$0: net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate_, $$1: net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate_): net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
        negate(): Internal.BiPredicate<Internal.WorldGenLevel, BlockPos>;
        static solid($$0: Vec3i_): net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
        static insideWorld($$0: Vec3i_): net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
        or(arg0: Internal.BiPredicate_<Internal.WorldGenLevel, BlockPos>): Internal.BiPredicate<Internal.WorldGenLevel, BlockPos>;
        static matchesTag($$0: Internal.TagKey_<Internal.Block>): net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
        static solid(): net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
        static alwaysTrue(): net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
        static matchesBlocks($$0: Vec3i_, ...$$1: Internal.Block_[]): net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
        static matchesBlocks($$0: Vec3i_, $$1: Internal.List_<Internal.Block>): net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
        static allOf(...$$0: net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate_[]): net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
        static replaceable(): net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
        static wouldSurvive($$0: Internal.BlockState_, $$1: Vec3i_): net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
        static matchesFluids($$0: Vec3i_, $$1: Internal.List_<Internal.Fluid>): net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
        static not($$0: net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate_): net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
        static matchesFluids($$0: Vec3i_, ...$$1: Internal.Fluid_[]): net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
        static allOf($$0: Internal.List_<net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate>): net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
        static allOf($$0: net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate_, $$1: net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate_): net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
        static anyOf(...$$0: net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate_[]): net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
        static replaceable($$0: Vec3i_): net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
        static hasSturdyFace($$0: Vec3i_, $$1: Internal.Direction_): net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
        static matchesBlocks(...$$0: Internal.Block_[]): net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
        static matchesBlocks($$0: Internal.List_<Internal.Block>): net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
        static matchesFluids(...$$0: Internal.Fluid_[]): net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
        static readonly CODEC: Internal.Codec<Internal.MatchingBlocksPredicate>;
    }
    type MatchingBlocksPredicate_ = MatchingBlocksPredicate;
    class SolidBucketItem extends Internal.BlockItem implements Internal.DispensibleContainerItem {
        constructor($$0: Internal.Block_, $$1: Internal.SoundEvent_, $$2: Internal.Item$Properties_)
        hasCustomEntity(stack: Internal.ItemStack_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        allowContinuingBlockBreaking(player: Internal.Player_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getRecipeRemainder(stack: Internal.ItemStack_): Internal.ItemStack;
        onArmorTick(stack: Internal.ItemStack_, level: Internal.Level_, player: Internal.Player_): void;
        setDigSpeed(speed: number): void;
        onItemUseFirst(stack: Internal.ItemStack_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        setAttackSpeed(attackSpeed: number): void;
        arch$registryName(): ResourceLocation;
        setAttackDamage(attackDamage: number): void;
        getAttributeModifiers(stack: Internal.ItemStack_, slot: Internal.EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        static port_lib$getPlayerPOVHitResult(level: Internal.Level_, player: Internal.Player_, fluidMode: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        arch$holder(): Internal.Holder<Internal.Item>;
        getMod(): string;
        static getBaseAttackDamageUUID(): Internal.UUID;
        createEntity(level: Internal.Level_, location: Internal.Entity_, stack: Internal.ItemStack_): Internal.Entity;
        emptyContents($$0: Internal.Player_, $$1: Internal.Level_, $$2: BlockPos_, $$3: Internal.BlockHitResult_): boolean;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        getCreativeTab(): string;
        setArmorToughness(armorToughness: number): void;
        onDroppedByPlayer(stack: Internal.ItemStack_, player: Internal.Player_): boolean;
        allowNbtUpdateAnimation(player: Internal.Player_, hand: Internal.InteractionHand_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getDefaultTooltipHideFlags(stack: Internal.ItemStack_): number;
        getCreatorModId(itemStack: Internal.ItemStack_): string;
        emi(amount: number): Internal.EmiStack;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        emi(): Internal.EmiStack;
        isSuitableFor(stack: Internal.ItemStack_, state: Internal.BlockState_): boolean;
        onLeftClickEntity(stack: Internal.ItemStack_, player: Internal.Player_, entity: Internal.Entity_): boolean;
        getDigSpeed(): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(itemstack: Internal.ItemStack_, pos: BlockPos_, player: Internal.Player_): boolean;
        removeFromBlockToItemMap(blockToItemMap: Internal.Map_<Internal.Block, Internal.Item>, itemIn: Internal.Item_): void;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        checkExtraContent($$0: Internal.Player_, $$1: Internal.Level_, $$2: Internal.ItemStack_, $$3: BlockPos_): void;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        set attackDamage(attackDamage: number)
        get mod(): string
        get baseAttackDamageUUID(): Internal.UUID
        set armorProtection(armorProtection: number)
        get creativeTab(): string
        set armorToughness(armorToughness: number)
        get digSpeed(): number
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
    }
    type SolidBucketItem_ = SolidBucketItem;
    class ItemStaff extends Internal.Item {
        constructor(pProperties: Internal.Item$Properties_)
        hasCustomEntity(stack: Internal.ItemStack_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        allowContinuingBlockBreaking(player: Internal.Player_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getRecipeRemainder(stack: Internal.ItemStack_): Internal.ItemStack;
        onArmorTick(stack: Internal.ItemStack_, level: Internal.Level_, player: Internal.Player_): void;
        setDigSpeed(speed: number): void;
        onItemUseFirst(stack: Internal.ItemStack_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        setAttackSpeed(attackSpeed: number): void;
        arch$registryName(): ResourceLocation;
        setAttackDamage(attackDamage: number): void;
        getAttributeModifiers(stack: Internal.ItemStack_, slot: Internal.EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        static port_lib$getPlayerPOVHitResult(level: Internal.Level_, player: Internal.Player_, fluidMode: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        arch$holder(): Internal.Holder<Internal.Item>;
        getMod(): string;
        static getBaseAttackDamageUUID(): Internal.UUID;
        createEntity(level: Internal.Level_, location: Internal.Entity_, stack: Internal.ItemStack_): Internal.Entity;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        getCreativeTab(): string;
        setArmorToughness(armorToughness: number): void;
        onDroppedByPlayer(stack: Internal.ItemStack_, player: Internal.Player_): boolean;
        allowNbtUpdateAnimation(player: Internal.Player_, hand: Internal.InteractionHand_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getDefaultTooltipHideFlags(stack: Internal.ItemStack_): number;
        getCreatorModId(itemStack: Internal.ItemStack_): string;
        emi(amount: number): Internal.EmiStack;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        emi(): Internal.EmiStack;
        isSuitableFor(stack: Internal.ItemStack_, state: Internal.BlockState_): boolean;
        onLeftClickEntity(stack: Internal.ItemStack_, player: Internal.Player_, entity: Internal.Entity_): boolean;
        getDigSpeed(): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(itemstack: Internal.ItemStack_, pos: BlockPos_, player: Internal.Player_): boolean;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        set attackDamage(attackDamage: number)
        get mod(): string
        get baseAttackDamageUUID(): Internal.UUID
        set armorProtection(armorProtection: number)
        get creativeTab(): string
        set armorToughness(armorToughness: number)
        get digSpeed(): number
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
        static readonly FUNNY_LEVEL_PREDICATE: ResourceLocation;
    }
    type ItemStaff_ = ItemStaff;
    abstract class MountedFluidStorageType <T extends Internal.MountedFluidStorage> {
        abstract mount(arg0: Internal.Level_, arg1: Internal.BlockState_, arg2: BlockPos_, arg3: Internal.BlockEntity_): T;
        static mountedFluidStorage<B extends Internal.Block, P>(type: Internal.RegistryEntry_<Internal.MountedFluidStorageType<any>>): Internal.NonNullUnaryOperator<com.tterrag.registrate.builders.BlockBuilder<B, P>>;
        static readonly CODEC: Internal.Codec<Internal.MountedFluidStorageType<any>>;
        static readonly REGISTRY: Internal.SimpleRegistry<Internal.Block, Internal.MountedFluidStorageType<any>>;
        readonly codec: Internal.Codec<T>;
    }
    type MountedFluidStorageType_<T extends Internal.MountedFluidStorage> = Special.MountedFluidStorageType | MountedFluidStorageType<T>;
    interface Person {
        abstract getName(): string;
        abstract getContact(): Internal.ContactInformation;
        get name(): string
        get contact(): Internal.ContactInformation
    }
    type Person_ = Person;
    interface FluidInformation {
        abstract fallDistanceModifier(): number;
        abstract density(): number;
        abstract tickDelay(): number;
        abstract explosionResistance(): number;
        abstract toProperties(): Internal.FluidProperties;
        abstract canSwim(): boolean;
        abstract rarity(): Internal.Rarity;
        abstract temperature(): number;
        abstract still(): ResourceLocation;
        abstract canConvertToSource(): boolean;
        abstract overlay(): ResourceLocation;
        abstract id(): ResourceLocation;
        abstract slopeFindDistance(): number;
        abstract supportsBloating(): boolean;
        abstract viscosity(): number;
        abstract lightLevel(): number;
        abstract canHydrate(): boolean;
        abstract adjacentPathType(): Internal.BlockPathTypes;
        abstract pathType(): Internal.BlockPathTypes;
        abstract canPlace(): boolean;
        abstract screenOverlay(): ResourceLocation;
        abstract flowing(): ResourceLocation;
        abstract dropOff(): number;
        abstract motionScale(): number;
        abstract tintColor(): number;
        abstract canDrown(): boolean;
        abstract sounds(): Internal.FluidSounds;
        abstract canPushEntity(): boolean;
        abstract canExtinguish(): boolean;
    }
    type FluidInformation_ = FluidInformation;
    class Dialog$ModalExclusionType extends Internal.Enum<Internal.Dialog$ModalExclusionType> {
        static values(): Internal.Dialog$ModalExclusionType[];
        static valueOf(arg0: string): Internal.Dialog$ModalExclusionType;
        static readonly NO_EXCLUDE: Internal.Dialog$ModalExclusionType;
        static readonly TOOLKIT_EXCLUDE: Internal.Dialog$ModalExclusionType;
        static readonly APPLICATION_EXCLUDE: Internal.Dialog$ModalExclusionType;
    }
    type Dialog$ModalExclusionType_ = "no_exclude" | "toolkit_exclude" | "application_exclude" | Dialog$ModalExclusionType;
    abstract class AbstractCauldronBlock extends Internal.Block {
        constructor($$0: Internal.BlockBehaviour$Properties_, $$1: Internal.Map_<Internal.Item, Internal.CauldronInteraction>)
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        abstract isFull(arg0: Internal.BlockState_): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        getBlockStates(): Internal.List<Internal.BlockState>;
        arch$holder(): Internal.Holder<Internal.Block>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        emi(amount: number): Internal.EmiStack;
        setRequiresTool(v: boolean): void;
        emi(): Internal.EmiStack;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        set destroySpeed(v: number)
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
    }
    type AbstractCauldronBlock_ = AbstractCauldronBlock;
    class ItemDragonFlesh extends Internal.ItemGenericFood {
        constructor(dragonType: number)
        hasCustomEntity(stack: Internal.ItemStack_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        allowContinuingBlockBreaking(player: Internal.Player_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getRecipeRemainder(stack: Internal.ItemStack_): Internal.ItemStack;
        onArmorTick(stack: Internal.ItemStack_, level: Internal.Level_, player: Internal.Player_): void;
        setDigSpeed(speed: number): void;
        onItemUseFirst(stack: Internal.ItemStack_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        setAttackSpeed(attackSpeed: number): void;
        arch$registryName(): ResourceLocation;
        setAttackDamage(attackDamage: number): void;
        getAttributeModifiers(stack: Internal.ItemStack_, slot: Internal.EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        static port_lib$getPlayerPOVHitResult(level: Internal.Level_, player: Internal.Player_, fluidMode: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        arch$holder(): Internal.Holder<Internal.Item>;
        getMod(): string;
        static getBaseAttackDamageUUID(): Internal.UUID;
        static getNameForType(dragonType: number): string;
        createEntity(level: Internal.Level_, location: Internal.Entity_, stack: Internal.ItemStack_): Internal.Entity;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        getCreativeTab(): string;
        setArmorToughness(armorToughness: number): void;
        onDroppedByPlayer(stack: Internal.ItemStack_, player: Internal.Player_): boolean;
        allowNbtUpdateAnimation(player: Internal.Player_, hand: Internal.InteractionHand_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getDefaultTooltipHideFlags(stack: Internal.ItemStack_): number;
        getCreatorModId(itemStack: Internal.ItemStack_): string;
        emi(amount: number): Internal.EmiStack;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        emi(): Internal.EmiStack;
        isSuitableFor(stack: Internal.ItemStack_, state: Internal.BlockState_): boolean;
        onLeftClickEntity(stack: Internal.ItemStack_, player: Internal.Player_, entity: Internal.Entity_): boolean;
        getDigSpeed(): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(itemstack: Internal.ItemStack_, pos: BlockPos_, player: Internal.Player_): boolean;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        set attackDamage(attackDamage: number)
        get mod(): string
        get baseAttackDamageUUID(): Internal.UUID
        set armorProtection(armorProtection: number)
        get creativeTab(): string
        set armorToughness(armorToughness: number)
        get digSpeed(): number
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
    }
    type ItemDragonFlesh_ = ItemDragonFlesh;
    class IcebergFeature extends Internal.Feature<Internal.BlockStateConfiguration> {
        constructor($$0: Internal.Codec_<Internal.BlockStateConfiguration>)
    }
    type IcebergFeature_ = IcebergFeature;
    interface SophisticatedPlayer {
        sophisticatedCore_openMenu(menuProvider: Internal.MenuProvider_, pos: BlockPos_): Internal.OptionalInt;
        sophisticatedCore_openMenu(menu: Internal.MenuProvider_, context: Internal.Consumer_<Internal.FriendlyByteBuf>): Internal.OptionalInt;
    }
    type SophisticatedPlayer_ = SophisticatedPlayer;
    class GenericTableBlock extends Internal.RetexturedTableBlock {
        constructor(builder: Internal.BlockBehaviour$Properties_, blockEntity: any_<Internal.BlockEntity>)
        canPlaceLiquid($$0: Internal.BlockGetter_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.Fluid_): boolean;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        pickupBlock($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_): Internal.ItemStack;
        getPickupSound(): Internal.Optional<Internal.SoundEvent>;
        getBlockStates(): Internal.List<Internal.BlockState>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        setRequiresTool(v: boolean): void;
        getTicker<T extends Internal.BlockEntity>($$0: Internal.Level_, $$1: Internal.BlockState_, $$2: Internal.BlockEntityType_<T>): Internal.BlockEntityTicker<T>;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        placeLiquid($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.FluidState_): boolean;
        getListener<T extends Internal.BlockEntity>($$0: Internal.ServerLevel_, $$1: T): Internal.GameEventListener;
        arch$holder(): Internal.Holder<Internal.Block>;
        emi(amount: number): Internal.EmiStack;
        emi(): Internal.EmiStack;
        get pickupSound(): Internal.Optional<Internal.SoundEvent>
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        set destroySpeed(v: number)
    }
    type GenericTableBlock_ = GenericTableBlock;
    abstract class ExcavatingBlockEntityImpl <R extends Internal.ExcavatingRecipe> extends Internal.ExcavatingBlockEntity<R> {
        getIcon(isPlayerSneaking: boolean): Internal.ItemStack;
        getComponent<C extends dev.onyxstudios.cca.api.v3.component.Component>(key: Internal.ComponentKey_<C>): C;
        containedFluidTooltip(tooltip: Internal.List_<net.minecraft.network.chat.Component>, isPlayerSneaking: boolean, handler: Internal.Storage_<Internal.FluidVariant>): boolean;
        invalidateCaps(): void;
        syncComponent(key: Internal.ComponentKey_<any>): void;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_, predicate: Internal.PlayerSyncPredicate_): void;
        asComponentProvider(): Internal.ComponentProvider;
        modifyAttached<A>(type: Internal.AttachmentType_<A>, modifier: Internal.UnaryOperator_<A>): A;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>): A;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_): void;
        getAttachedOrGet<A>(type: Internal.AttachmentType_<A>, defaultValue: Internal.Supplier_<A>): A;
        getInfiniteBoundingBox(): Internal.AABB;
        static transfer(original: Internal.AttachmentTarget_, target: Internal.AttachmentTarget_, isDeath: boolean): void;
        getAttachedOrElse<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>, initializer: Internal.Supplier_<A>): A;
        self(): Internal.BlockEntity;
        etf$getETFRenderState(): Internal.ETFEntityRenderState;
        onLoad(): void;
        getAttachedOrSet<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        getAttachedOrThrow<A>(type: Internal.AttachmentType_<A>): A;
        removeAttached<A>(type: Internal.AttachmentType_<A>): A;
        get infiniteBoundingBox(): Internal.AABB
    }
    type ExcavatingBlockEntityImpl_<R extends Internal.ExcavatingRecipe> = ExcavatingBlockEntityImpl<R>;
}
declare namespace net.minecraft.world {
    interface Container extends Internal.InventoryMixin, Internal.LithiumCooldownReceivingInventory, Internal.Clearable, Internal.InventoryKJS {
        stopOpen($$0: Internal.Player_): void;
        count(ingredient: Internal.Ingredient_): number;
        tryClear($$0: any): void;
        count(): number;
        setTransferCooldown(currentTime: number): void;
        countItem($$0: Internal.Item_): number;
        setStackInSlot(slot: number, stack: Internal.ItemStack_): void;
        abstract isEmpty(): boolean;
        clear(ingredient: Internal.Ingredient_): void;
        startOpen($$0: Internal.Player_): void;
        canPlaceItem($$0: number, $$1: Internal.ItemStack_): boolean;
        find(): number;
        hasAnyOf($$0: Internal.Set_<Internal.Item>): boolean;
        abstract removeItem(arg0: number, arg1: number): Internal.ItemStack;
        getSlots(): number;
        extractItem(slot: number, amount: number, simulate: boolean): Internal.ItemStack;
        abstract setChanged(): void;
        getBlock(level: Internal.Level_): Internal.BlockContainerJS;
        stillValidBlockEntity($$0: Internal.BlockEntity_, $$1: Internal.Player_, $$2: number): boolean;
        abstract getContainerSize(): number;
        canReceiveTransferCooldown(): boolean;
        getStackInSlot(slot: number): Internal.ItemStack;
        abstract setItem(arg0: number, arg1: Internal.ItemStack_): void;
        getHeight(): number;
        hasAnyMatching($$0: Internal.Predicate_<Internal.ItemStack>): boolean;
        countNonEmpty(): number;
        asContainer(): this;
        kjs$self(): this;
        getWidth(): number;
        getSlotLimit(slot: number): number;
        getMaxStackSize(): number;
        getAllItems(): Internal.List<Internal.ItemStack>;
        abstract removeItemNoUpdate(arg0: number): Internal.ItemStack;
        stillValidBlockEntity($$0: Internal.BlockEntity_, $$1: Internal.Player_): boolean;
        canTakeItem($$0: net.minecraft.world.Container_, $$1: number, $$2: Internal.ItemStack_): boolean;
        insertItem(stack: Internal.ItemStack_, simulate: boolean): Internal.ItemStack;
        abstract stillValid(arg0: Internal.Player_): boolean;
        insertItem(slot: number, stack: Internal.ItemStack_, simulate: boolean): Internal.ItemStack;
        isMutable(): boolean;
        clear(): void;
        abstract getItem(arg0: number): Internal.ItemStack;
        find(ingredient: Internal.Ingredient_): number;
        abstract clearContent(): void;
        countNonEmpty(ingredient: Internal.Ingredient_): number;
        isItemValid(slot: number, stack: Internal.ItemStack_): boolean;
        set transferCooldown(currentTime: number)
        get empty(): boolean
        get slots(): number
        get containerSize(): number
        get height(): number
        get width(): number
        get maxStackSize(): number
        get allItems(): Internal.List<Internal.ItemStack>
        get mutable(): boolean
        readonly LARGE_MAX_STACK_SIZE: 64;
        readonly DEFAULT_DISTANCE_LIMIT: 8;
    }
    type Container_ = Container;
}
declare namespace io.github.fabricators_of_create.porting_lib.mixin.accessors.client.accessor {
    interface RenderTypeAccessor {
        port_lib$create(string: string, vertexFormat: Internal.VertexFormat_, mode: Internal.VertexFormat$Mode_, i: number, bl: boolean, bl2: boolean, compositeState: Internal.RenderType$CompositeState_): Internal.RenderType$CompositeRenderType;
    }
    type RenderTypeAccessor_ = RenderTypeAccessor;
}
